/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.postprocessing.samtools;

import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class SAMToolsSortJob
extends ISWFJob {
    public static final String JOB_ID = "samtools_sort";
    public static final String JOB_NAME = "Samtools : Sort";
    public static final String INPUT_BAM_FILES = "INPUT_FILES";
    public static final String OUTPUT_BAM_FILES = "OUTPUT_BAM_FILES";

    public SAMToolsSortJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Samtools Sort tool sort alignments by leftmost coordinates, or by read name.");
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Aligned Reads Files");
        varReadInputFile.setHelpMsg("Input [Bam|SAM|CRAM] Files to sort.");
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("Bam Files");
        bamOutputFile.setHelpMsg("Bam Files");
        this.jobDesc.addVariable(bamOutputFile);
    }

    protected void createOptions() {
        IntVariableDescriptor optionVarInt = VariableDescriptor.Int((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarInt.setVariableName("Compression Level");
        optionVarInt.setHelpMsg("Set the desired compression level for the final output file, ranging from 0 (uncompressed) or 1 (fastest but minimal compression) to 9 (best compression but slowest to write), similarly to gzip(1)'s compression level setting.");
        optionVarInt.setMaxValue(9.0);
        optionVarInt.setMinValue(0.0);
        optionVarInt.setCommandParamater("-I");
        this.jobDesc.addVariable((VariableDescriptor)optionVarInt);
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Sort by Names");
        optionVar.setHelpMsg("Sort by read names (i.e., the QNAME field) rather than by chromosomal coordinates");
        optionVar.setCommandParamater("-n");
        this.jobDesc.addVariable(optionVar);
        SelectionListVariableDescriptor optionVarSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.setVariableName("Output Format");
        optionVarSelectionList.setHelpMsg("By default will be the same as the input format.");
        optionVarSelectionList.addOptionValue("Bam", "bam", "Bam file fromat");
        optionVarSelectionList.addOptionValue("Sam", "sam", "Sam file fromat");
        optionVarSelectionList.addOptionValue("Cram", "cram", "Cram file fromat");
        optionVarSelectionList.setCommandParamater("-O");
        this.jobDesc.addVariable((VariableDescriptor)optionVarSelectionList);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = "samtools sort ";
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(INPUT_BAM_FILES);
        FilesVariable outputBamFilesVar = (FilesVariable)this.getVariable(OUTPUT_BAM_FILES);
        builder.append(SAMToolsSortJob.st((String)"_ext=\"bam\""));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)SAMToolsSortJob.st((String)BashHelper.arrayAdd((JobVariable)outputBamFilesVar, (String)"${outputFolder}/${inputFileBaseName}.${_ext}")), (String)(String.valueOf(cmdPrefix) + this.getOptionParamatersStrAs$() + " -o" + outputBamFilesVar.$("${_i}") + " ${_inputFile}"), (String)"samtools sort"));
    }
}

