/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.userservice.filetransfer;

import com.biotechvana.commons.ftpservice.FtpFileTransfer;
import com.biotechvana.commons.ftpservice.TransferStatus;
import com.biotechvana.commons.ftpservice.TransferType;
import com.biotechvana.userservice.filetransfer.FileTransferJobImpl;
import com.biotechvana.userservice.filetransfer.FileTransferListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.Util;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.eclipse.core.runtime.OperationCanceledException;

public class FtpFileTransferImpl
extends FtpFileTransfer {
    public FileObject source;
    public FileObject destination;
    FileTransferListener progressMonitor;

    public FtpFileTransferImpl(FileObject source, FileObject destination, long size, TransferType transferType, FileTransferJobImpl transferJob) {
        this.source = source;
        this.destination = destination;
        this.transferType = transferType;
        this.transferJob = transferJob;
        this.totolSize = size;
        this.transferedBytes = 0L;
        this.progressMonitor = new FileTransferListener();
        this.progressMonitor.fileTransferJob = this;
        this.progressMonitor.destFile = destination;
    }

    public String getSourceName() {
        return this.source.getName().getBaseName();
    }

    public String getSourcePath() {
        return this.source.getName().getPath();
    }

    public String getDestinationParentPath() {
        try {
            return this.destination.getParent().getName().getPath();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDestinationPath() {
        try {
            return this.destination.getName().getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void startTransfer() {
        this.setStatus(TransferStatus.RUNNING);
        try {
            this.copyFrom();
        }
        catch (FileSystemException e) {
            this.setStatus(TransferStatus.ERROR);
            e.printStackTrace();
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
            this.setStatus(TransferStatus.STOPED);
        }
        System.out.println(this.source.getName().getBaseName() + " download complete.");
    }

    private void copyFrom_folder(FileSelector selector) throws FileSystemException {
        if (!FileObjectUtils.exists((FileObject)this.source)) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", (Object)this.source);
        }
        ArrayList files = new ArrayList();
        this.source.findFiles(selector, false, files);
        for (FileObject srcFile : files) {
            String relPath = this.source.getName().getRelativeName(srcFile.getName());
            FileObject destFile = this.destination.resolveFile(relPath, NameScope.DESCENDENT_OR_SELF);
            if (FileObjectUtils.exists((FileObject)destFile) && destFile.getType() != srcFile.getType()) {
                destFile.deleteAll();
            }
            try {
                if (srcFile.getType().hasContent()) {
                    this.setStatus(TransferStatus.FINISHED);
                    continue;
                }
                if (!srcFile.getType().hasChildren()) continue;
                destFile.createFolder();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/copy-file.error", (Throwable)e, new Object[]{srcFile, destFile});
            }
        }
    }

    private void copyFrom() throws FileSystemException {
        if (!FileObjectUtils.exists((FileObject)this.source)) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", (Object)this.source);
        }
        String relPath = this.source.getName().getRelativeName(this.source.getName());
        FileObject destFile = this.destination.resolveFile(relPath, NameScope.DESCENDENT_OR_SELF);
        if (FileObjectUtils.exists((FileObject)destFile) && destFile.getType() != this.source.getType()) {
            destFile.deleteAll();
        }
        try {
            if (this.source.getType().hasContent()) {
                FtpFileTransferImpl.writeContent(this.source, destFile, this.progressMonitor);
                this.setStatus(TransferStatus.FINISHED);
            }
        }
        catch (IOException e) {
            throw new FileSystemException("vfs.provider/copy-file.error", (Throwable)e, new Object[]{this.source, destFile});
        }
    }

    private static void writeContent(FileObject sourceFile, FileObject destinationFile, CopyStreamListener progressMonitor) throws IOException {
        try (InputStream sourceFileIn = sourceFile.getContent().getInputStream();
             OutputStream destinationFileOut = destinationFile.getContent().getOutputStream();){
            Util.copyStream((InputStream)sourceFileIn, (OutputStream)destinationFileOut, (int)0x7D0000, (long)sourceFile.getContent().getSize(), (CopyStreamListener)progressMonitor);
        }
    }

    public void stop() {
        this.setStatus(TransferStatus.CANCELING);
    }
}

