/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.ftpqueue;

import com.biotechvana.commons.ftpservice.IFTPQueue;
import com.biotechvana.commons.ftpservice.IFTPQueueListener;
import com.biotechvana.commons.ftpservice.IFTPTransfer;
import com.biotechvana.commons.ftpservice.IFileTransferJob;
import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.ui.ftpqueue.ActiveTransfersView;
import com.biotechvana.ui.ftpqueue.DoneTransfersView;
import com.biotechvana.ui.ftpqueue.TransferJobsView;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class FTPQueueViewer {
    public static final String ID = "com.biotechvana.ui.ftpqueue.FTPQueueViewer";
    @Inject
    private MPart part;
    @Inject
    @Named(value="activeShell")
    private Shell activeShell;
    @Optional
    @Inject
    IStatusLineManager statusLine;
    UserLoginInfo activeLogin;
    IFTPQueueListener handler;
    private List<IFileTransferJob> jobList;
    private List<IFtpFileTransfer> activeFileList;
    private List<IFtpFileTransfer> doneFileList;
    private List<IFileTransferJob> doneJobList;
    private Label label;
    TabFolder tabFodler;
    TabItem activeTab;
    TabItem jobTab;
    TabItem doneTab;
    ActiveTransfersView activeTransfersView;
    TransferJobsView tranferJobsView;
    DoneTransfersView doneTransfersView;
    private Display current_display;
    @Inject
    private IFTPQueue ftpQueue;
    Timer timer = new Timer();

    @PostConstruct
    public void createPartControl(Composite parent) {
        this.current_display = parent.getDisplay();
        this.jobList = this.ftpQueue.getJobs();
        this.activeFileList = this.ftpQueue.getActiveFiles();
        this.doneFileList = this.ftpQueue.getDoneFiles();
        this.doneJobList = this.ftpQueue.getDoneJobs();
        parent.setLayout((Layout)new FillLayout());
        this.tabFodler = new TabFolder(parent, 2048);
        this.activeTab = new TabItem(this.tabFodler, 0);
        this.activeTab.setText("Active");
        this.jobTab = new TabItem(this.tabFodler, 0);
        this.jobTab.setText("Jobs");
        this.doneTab = new TabItem(this.tabFodler, 0);
        this.doneTab.setText("Done");
        this.label = new Label((Composite)this.tabFodler, 0);
        this.jobTab.setControl((Control)this.label);
        this.activeTransfersView = new ActiveTransfersView();
        this.activeTransfersView.createPartControl((Composite)this.tabFodler);
        this.activeTab.setControl(this.activeTransfersView.getControl());
        this.activeTransfersView.setInput(this.activeFileList);
        this.tranferJobsView = new TransferJobsView();
        this.tranferJobsView.createPartControl((Composite)this.tabFodler);
        this.jobTab.setControl(this.tranferJobsView.getControl());
        this.tranferJobsView.setInput(this.jobList);
        this.doneTransfersView = new DoneTransfersView();
        this.doneTransfersView.createPartControl((Composite)this.tabFodler);
        this.doneTab.setControl(this.doneTransfersView.getControl());
        this.doneTransfersView.setInput(this.doneFileList);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                FTPQueueViewer.this.updateUI();
            }
        }, 2500L, 2500L);
    }

    void updateUI() {
        this.current_display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (FTPQueueViewer.this.tabFodler.isDisposed()) {
                    return;
                }
                FTPQueueViewer.this.activeTransfersView.updateUI();
                FTPQueueViewer.this.doneTransfersView.updateUI();
            }
        });
    }

    @PreDestroy
    public void cleanUp() {
        this.tranferJobsView.cleanUp();
        this.timer.cancel();
    }

    @Inject
    @Optional
    private void newFileTransferJobHandler(@UIEventTopic(value="TRANSFER_JOB/NEW") IFileTransferJob newJob) {
        System.out.println("TRANSFER_JOB_NEW");
        this.jobList.add(newJob);
        this.tranferJobsView.updateUI();
    }

    @Inject
    @Optional
    private void statusChangeFileTransferJobHandler(@EventTopic(value="TRANSFER_JOB/CHANGED") IFileTransferJob refJob) {
        System.out.println("TRANSFER_JOB_STATUS_CHANGE " + String.valueOf(refJob.getStatus()));
        if (refJob.isFinished()) {
            this.doneJobList.add(refJob);
        }
        this.tranferJobsView.toBeUpdated((IFTPTransfer)refJob);
    }

    @Inject
    @Optional
    private void updateFileTransferJobHandler(@EventTopic(value="TRANSFER_JOB/UPDATED") IFileTransferJob refJob) {
        System.out.println("TRANSFER_JOB_UPDATE" + String.valueOf(refJob));
        this.tranferJobsView.toBeUpdated((IFTPTransfer)refJob);
    }

    @Inject
    @Optional
    private void newFtpFileTransferHandler(@EventTopic(value="TRANSFER_FILE/NEW") IFtpFileTransfer newFileTransfer) {
        this.tranferJobsView.setViewerStructureChange(newFileTransfer.getJob());
    }

    @Inject
    @Optional
    private void statusChangeFtpFileTransferHandler(@EventTopic(value="TRANSFER_FILE/CHANGED") IFtpFileTransfer ftpFileTransfer) {
        System.out.println("TRANSFER_FILE_STATUS_CHANGE : " + ftpFileTransfer.getSourcePath() + " : " + String.valueOf(ftpFileTransfer.getStatus()));
        switch (ftpFileTransfer.getStatus()) {
            case RUNNING: {
                this.activeFileList.add(ftpFileTransfer);
                break;
            }
            case STOPED: 
            case FINISHED: 
            case ERROR: {
                this.doneFileList.add(ftpFileTransfer);
                this.activeFileList.remove(ftpFileTransfer);
                break;
            }
        }
        this.tranferJobsView.toBeUpdated((IFTPTransfer)ftpFileTransfer);
    }

    @Inject
    @Optional
    private void updateFtpFileTransferHandler(@EventTopic(value="TRANSFER_FILE/UPDATED") IFtpFileTransfer ftpFileTransfer) {
        this.tranferJobsView.toBeUpdated((IFTPTransfer)ftpFileTransfer);
        this.tranferJobsView.toBeUpdated((IFTPTransfer)ftpFileTransfer.getJob());
    }
}

