/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.variables;

import com.biotechvana.utils.StringUtils;
import com.biotechvana.workflow.CmdListMergeStrategy;
import com.biotechvana.workflow.IListVariableDescriptor;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.List;

public class StringsJobVariable
extends JobVariable {
    protected StringsJobVariable(WorkflowJob containerJob, VariableDescriptor varDesc) {
        super(containerJob, varDesc);
        StringsJobVariable.checkType(varDesc, VariableDescriptor.VariableType.Strings);
    }

    @Override
    protected String onGetBashVarDecleration() {
        Object str = "";
        String varName = this.getBashVarName();
        if (this.desc.getVarType() == VariableDescriptor.VariableType.Strings) {
            String[] lines = this.value.split("\n");
            str = (String)str + "# which is an array of Strings \n";
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!(line = line.trim()).isEmpty()) {
                    str = (String)str + BashHelper.arrayAdd(this, line) + "\n";
                }
                ++n2;
            }
            return str;
        }
        return "";
    }

    @Override
    public String get_cmdValue() {
        JobVariable thisOrMapped = this;
        if (this.hasMapping()) {
            thisOrMapped = this.mappedToVar;
        }
        if (this.value.isEmpty()) {
            return null;
        }
        if (((IListVariableDescriptor)((Object)this.desc)).getCmdListMergeStrategy() == CmdListMergeStrategy.Indexed) {
            return null;
        }
        if (((IListVariableDescriptor)((Object)this.desc)).getCmdListMergeStrategy() == CmdListMergeStrategy.Once) {
            return this.desc.getCommandParamater() + this.desc.getCommandParamaterSep() + BashHelper.hlpArrAppend(thisOrMapped, ((IListVariableDescriptor)((Object)this.desc)).getCmdListMergerSep());
        }
        return BashHelper.hlpCmdSwitchAppend(thisOrMapped, this.desc.getCommandParamater(), this.desc.getCommandParamaterSep(), ((IListVariableDescriptor)((Object)this.desc)).getCmdListMergerQuate());
    }

    @Override
    protected String get_cmdValuePrefix() {
        return "";
    }

    public String[] getStringsList() {
        if (StringUtils.isEmpty((String)this.value)) {
            return new String[0];
        }
        String[] strings = this.getValue().split("\n");
        return strings;
    }

    public void addString(String newValue) {
        if (!StringUtils.isEmpty((String)this.value)) {
            newValue = this.value + "\n" + (String)newValue;
        }
        this.setValue((String)newValue);
    }

    public void setValue(List<String> values) {
        Object newStrValue = "";
        for (String value : values) {
            newStrValue = (String)newStrValue + value + "\n";
        }
        this.setValue((String)newStrValue);
    }
}

