/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.variables;

import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.NumVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.JobVariable;

public class SimpleVariable
extends JobVariable {
    protected SimpleVariable(WorkflowJob containerJob, VariableDescriptor varDesc) {
        super(containerJob, varDesc);
    }

    @Override
    protected void onValidate() {
        if (this.desc.getVarType() == VariableDescriptor.VariableType.Int && this.value != null && !this.value.isEmpty()) {
            try {
                int val = Integer.parseInt(this.value);
                if (((NumVariableDescriptor)this.desc).isMaxValueSet && (double)val > ((NumVariableDescriptor)this.desc).getMaxValue()) {
                    this.errorMsg = this.desc.getVariableName() + "Should be <=(" + ((NumVariableDescriptor)this.desc).getMaxValue() + ") and >=(" + ((NumVariableDescriptor)this.desc).getMinValue() + ").";
                    this._isValid = false;
                }
                if (((NumVariableDescriptor)this.desc).isMinValueSet && (double)val < ((NumVariableDescriptor)this.desc).getMinValue()) {
                    this.errorMsg = this.desc.getVariableName() + "Should be <=(" + ((NumVariableDescriptor)this.desc).getMaxValue() + ") and >=(" + ((NumVariableDescriptor)this.desc).getMinValue() + ").";
                    this._isValid = false;
                }
            }
            catch (Exception ex) {
                this.errorMsg = this.desc.getVariableName() + " is not a valid Integer Value.";
                this._isValid = false;
            }
        }
        if (this.desc.getVarType() == VariableDescriptor.VariableType.String && this.desc.isFileName()) {
            if (this.value.contains("/") || this.value.contains("\\") || this.value.contains("`") || this.value.contains("\"") || this.value.contains("'")) {
                this.errorMsg = "Not valid File Name";
                this._isValid = false;
            }
            if (this.value.contains(" ")) {
                this.setWarning("Avoid using Space for the prefix name. Underscore(_) is used instead.");
                this.value = this.value.replace(" ", "_");
            }
        }
        if (this.desc.getVarType() == VariableDescriptor.VariableType.Double && this.value != null && !this.value.isEmpty()) {
            try {
                double val = Double.parseDouble(this.value);
                if (((NumVariableDescriptor)this.desc).isMaxValueSet && val > ((NumVariableDescriptor)this.desc).getMaxValue()) {
                    this.errorMsg = this.desc.getVariableName() + "Should be <=(" + ((NumVariableDescriptor)this.desc).getMaxValue() + ") and >=(" + ((NumVariableDescriptor)this.desc).getMinValue() + ").";
                    this._isValid = false;
                }
                if (((NumVariableDescriptor)this.desc).isMinValueSet && val < ((NumVariableDescriptor)this.desc).getMinValue()) {
                    this.errorMsg = this.desc.getVariableName() + "Should be <=(" + ((NumVariableDescriptor)this.desc).getMaxValue() + ") and >=(" + ((NumVariableDescriptor)this.desc).getMinValue() + ").";
                    this._isValid = false;
                }
            }
            catch (Exception ex) {
                this.errorMsg = this.desc.getVariableName() + " is not a valid Double Value.";
                this._isValid = false;
            }
        }
        super.onValidate();
    }

    @Override
    protected String onGetBashVarDecleration() {
        if (this.desc.getVarType() == VariableDescriptor.VariableType.String || this.desc.getVarType() == VariableDescriptor.VariableType.Int || this.desc.getVarType() == VariableDescriptor.VariableType.Range || this.desc.getVarType() == VariableDescriptor.VariableType.Double) {
            return this.getBashVarName() + "=\"" + this.value + "\" \n\n";
        }
        return "";
    }

    public double getDescMinValue() {
        return ((NumVariableDescriptor)this.desc).getMinValue();
    }

    public double getDescMaxValue() {
        return ((NumVariableDescriptor)this.desc).getMaxValue();
    }

    public boolean getDescIsMaxValueSet() {
        return ((NumVariableDescriptor)this.desc).getIsMaxValueSet();
    }

    public boolean getDescIsMinValueSet() {
        return ((NumVariableDescriptor)this.desc).getIsMinValueSet();
    }

    @Override
    public String get_cmdValue() {
        return this.value;
    }

    public void setMaxValue(double maxValue) {
        if (this.desc instanceof NumVariableDescriptor) {
            ((NumVariableDescriptor)this.desc).setMaxValue(maxValue);
        }
    }

    public void setMinValue(double minValue) {
        if (this.desc instanceof NumVariableDescriptor) {
            ((NumVariableDescriptor)this.desc).setMinValue(minValue);
        }
    }
}

