/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.variables;

import com.biotechvana.pipelinestools.utils.PipelineUtils;
import com.biotechvana.workflow.CmdListMergeStrategy;
import com.biotechvana.workflow.IListVariableDescriptor;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.List;

public class FilesVariable
extends FileVariable {
    public FilesVariable(WorkflowJob containerJob, VariableDescriptor varDesc) {
        super(containerJob, varDesc);
    }

    @Override
    protected String onGetBashVarDecleration() {
        String varName = this.getBashVarName();
        Object str = "";
        if (this.desc.getVarType() == VariableDescriptor.VariableType.Files || this.desc.getVarType() == VariableDescriptor.VariableType.Folders) {
            String[] lines = this.value.split("\n");
            int counter = 0;
            str = (String)str + "# which is an array of Files/Folders \n";
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.isEmpty()) {
                    str = (String)str + varName + "[" + counter + "]=\"" + PipelineUtils.sanitizeFilePathWithTelda(this.containerJob.getWorkflowManager().getUserManager().getHostPathManager().getUserHomePath(), line, this.containerJob.getWorkflowManager().getUserManager().getIsChRooted()) + "\" \n";
                    ++counter;
                }
                ++n2;
            }
            return str;
        }
        return "";
    }

    @Override
    protected String get_cmdValuePrefix() {
        return " ";
    }

    @Override
    public String get_cmdValue() {
        if (this.value.isEmpty() && !this.hasMapping()) {
            return null;
        }
        JobVariable refVar = this;
        if (this.hasMapping()) {
            refVar = this.mappedToVar;
        }
        if (((IListVariableDescriptor)((Object)this.desc)).getCmdListMergeStrategy() == CmdListMergeStrategy.Indexed) {
            throw new IllegalArgumentException("CmdListMergeStrategy.Indexed not implemented");
        }
        if (((IListVariableDescriptor)((Object)this.desc)).getCmdListMergeStrategy() == CmdListMergeStrategy.Once) {
            return this.desc.getCommandParamater() + this.desc.getCommandParamaterSep() + BashHelper.hlpArrAppend(refVar, ((IListVariableDescriptor)((Object)this.desc)).getCmdListMergerSep());
        }
        if (((IListVariableDescriptor)((Object)this.desc)).getCmdListMergeStrategy() == CmdListMergeStrategy.Repeat) {
            return BashHelper.hlpCmdSwitchAppend(refVar, this.desc.getCommandParamater(), this.desc.getCommandParamaterSep());
        }
        return null;
    }

    public void setValue(List<String> files) {
        Object valueStr = "";
        for (String file : files) {
            valueStr = (String)valueStr + file + "\n";
        }
        this.setValue((String)valueStr);
    }
}

