/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.tracking;

import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import com.biotechvana.workflow.tracking.events.CheckTrackEvent;
import com.biotechvana.workflow.tracking.events.EndTrackEvent;
import com.biotechvana.workflow.tracking.events.InfoTrackEvent;
import com.biotechvana.workflow.tracking.events.ProcessingFinishedTrackEvent;
import com.biotechvana.workflow.tracking.events.ProcessingTrackEvent;
import com.biotechvana.workflow.tracking.events.StartTrackEvent;
import com.biotechvana.workflow.tracking.events.SubProcessTrackEvent;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TrackerInfoEntry
implements ITrackerInfo {
    String pid;
    String ppid;
    String fileName;
    protected long time;
    protected Tracking.TrackEventType eventtype;
    protected String subTaskName;
    protected String logMsg;
    String[] rawTokens;

    public void setStartTime(long value) {
        this.time = value;
    }

    public long getStartTime() {
        return this.time;
    }

    public void setEventtype(Tracking.TrackEventType eventType) {
        this.eventtype = eventType;
    }

    public Tracking.TrackEventType getEventtype() {
        return this.eventtype;
    }

    public void setSubTaskName(String value) {
        this.subTaskName = value;
    }

    public String getSubTaskName() {
        return this.subTaskName;
    }

    @Override
    public void setLogMsg(String value) {
        this.logMsg = value;
    }

    @Override
    public String getLogMsg() {
        return this.logMsg;
    }

    private TrackerInfoEntry() {
    }

    public TrackerInfoEntry(String[] tokens) {
        this.rawTokens = (String[])tokens.clone();
        String[] timeStampPID = tokens[0].split("\\$");
        if (timeStampPID.length > 1) {
            this.ppid = timeStampPID[1];
            this.pid = timeStampPID[2];
        }
        long time = Long.parseLong(timeStampPID[0]);
        Tracking.TrackEventType type = Tracking.TrackEventType.valueOf(tokens[1]);
        this.setStartTime(time);
        this.setEventtype(type);
    }

    public String getEventLine() {
        Object line = "";
        String[] stringArray = this.rawTokens;
        int n = this.rawTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            line = ((String)line).isEmpty() ? token : (String)line + "\t" + token;
            ++n2;
        }
        return ((String)line).strip();
    }

    public static TrackerInfoEntry from(String[] tokens) {
        String subTaskName = "";
        Tracking.TrackEventType type = Tracking.TrackEventType.valueOf(tokens[1]);
        TrackerInfoEntry newInfo = null;
        if (type == Tracking.TrackEventType.SubProcess) {
            newInfo = new SubProcessTrackEvent(tokens);
        } else if (type == Tracking.TrackEventType.Check) {
            newInfo = new CheckTrackEvent(tokens);
        } else if (type == Tracking.TrackEventType.Processing) {
            newInfo = new ProcessingTrackEvent(tokens);
        } else if (type == Tracking.TrackEventType.Ended) {
            newInfo = new EndTrackEvent(tokens);
        } else if (type == Tracking.TrackEventType.Started) {
            newInfo = new StartTrackEvent(tokens);
        } else if (type == Tracking.TrackEventType.Processed || type == Tracking.TrackEventType.ProcessingFail) {
            newInfo = new ProcessingFinishedTrackEvent(tokens);
        } else if (type == Tracking.TrackEventType.Info) {
            newInfo = InfoTrackEvent.create(tokens);
        } else {
            newInfo = new TrackerInfoEntry(tokens);
            Object logMsg = "";
            if (type == Tracking.TrackEventType.LogMsg) {
                logMsg = tokens[2];
            } else if (type == Tracking.TrackEventType.Warning) {
                logMsg = "Warning : " + tokens[2];
                if (tokens.length > 3) {
                    logMsg = (String)logMsg + "\t " + tokens[3];
                }
            } else if (type == Tracking.TrackEventType.Paused) {
                logMsg = "Job has been suspended.";
            } else if (type == Tracking.TrackEventType.Resumed) {
                logMsg = "Job has been resumed.";
            } else if (type == Tracking.TrackEventType.Canceled) {
                logMsg = "Job has been stoped.";
            } else if (type == Tracking.TrackEventType.Failed) {
                subTaskName = tokens[2];
                logMsg = subTaskName + " Failed.";
            } else if (tokens.length > 2) {
                subTaskName = tokens[2];
                if (tokens.length > 3) {
                    logMsg = tokens[3];
                }
            }
            newInfo.setLogMsg((String)logMsg);
        }
        newInfo.setSubTaskName(subTaskName);
        return newInfo;
    }

    @Override
    public String getTime() {
        return new SimpleDateFormat("dd-MM-YYYY  HH:mm:ss").format(new Date(this.time * 1000L));
    }

    @Override
    public String getTaskName() {
        return this.subTaskName;
    }

    @Override
    public ExecStatus getExecStatus() {
        return null;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int level) {
        Object preTab = "";
        int i = 0;
        while (i < level) {
            preTab = (String)preTab + "\t";
            ++i;
        }
        return (String)preTab + this.time + "\t" + this.subTaskName + "\t" + String.valueOf((Object)this.eventtype) + "\t" + this.logMsg + "\n";
    }

    @Override
    public String toTrackInfo(int level) {
        if (this.getEventtype() == Tracking.TrackEventType.Info) {
            return "";
        }
        Object preTab = "";
        int i = 0;
        while (i < level) {
            preTab = (String)preTab + "\t";
            ++i;
        }
        String timeStamp = new SimpleDateFormat("dd-MM-YYYY  HH:mm:ss").format(new Date(this.time * 1000L));
        return (String)preTab + "[" + timeStamp + "]\t" + String.valueOf((Object)this.eventtype) + "\t" + this.logMsg + "\n";
    }

    @Override
    public String getPID() {
        return this.pid;
    }

    @Override
    public String getPPID() {
        return this.ppid;
    }
}

