/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.template;

import com.biotechvana.workflow.WorkflowMetadata;
import com.biotechvana.workflow.template.WorkflowTemplate;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;

public class WorkflowTemplateWriter {
    static final int WRITER_VERSION = 1;
    public static final String WRITER_VERSION_PROP = "Version";
    public static final String METADATA_PROP = "Metadata";
    public static final String DEFAULT_NAME_PROP = "Default Name";
    public static final String TASK_LIST_PROP = "Tasks";
    public static final String STARTUP_TASK_PROP = "Startup";
    public static final String VARIABLE_MAP_FROM_PROP = "Source Mapping";
    public static final String VARIABLE_MAP_TO_PROP = "Target Mapping";
    public static final String CUSTOM_VALUES_PROP = "Values";
    public static final String RECOMMEDATION_LIST_PROP = "Recommended";
    public static final String INPUT_LIST_PROP = "INPUT";
    public static final String OUTPUT_LIST_PROP = "OUTPUT";
    WorkflowTemplateSerializer workflowMetadataSerializer = new WorkflowTemplateSerializer();
    Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().registerTypeAdapter(WorkflowTemplate.class, (Object)this.workflowMetadataSerializer).create();
    static final String JOB_START_TOKEN = "#Jobs";
    static final String MAP_START_TOKEN = "#Map";
    static final String VALUE_START_TOKEN = "#Values";
    static final String PRO_START_TOKEN = "#Properties";
    static final String WORK_FLOWNAME_TOKEN = "#Name";

    public void write(WorkflowTemplate template1, String string) {
        StringBuilder workflowStructure = new StringBuilder();
        StringWriter strWriter = new StringWriter();
        try {
            template1.getMetadata().store(strWriter, METADATA_PROP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        workflowStructure.append(strWriter.toString());
        workflowStructure.append("#Name\t" + template1.getDefaultWorkflowName() + "\n");
        workflowStructure.append("#Jobs\n");
        for (String tasks : template1.tasksIdToJobDescId.keySet()) {
            workflowStructure.append(tasks + "\t" + template1.tasksIdToJobDescId.get(tasks) + "\n");
        }
        workflowStructure.append("#Map\n");
        int i = 0;
        while (i < template1.varMapFrom.size()) {
            workflowStructure.append(template1.varMapFrom.get(i) + "=" + template1.varMapTo.get(i) + "\n");
            ++i;
        }
        workflowStructure.append("#Values\n");
        for (String varKey : template1.customVariableValues.keySet()) {
            String value = template1.customVariableValues.get(varKey);
            value = value.replace("\n", ";");
            workflowStructure.append(varKey + "=" + value);
            workflowStructure.append("\n");
        }
    }

    public void writeGSON(WorkflowTemplate template1, String fileName) throws IOException {
        BufferedWriter br = new BufferedWriter(new FileWriter(fileName));
        br.write(this.gson.toJson((Object)template1));
        br.close();
    }

    class WorkflowTemplateSerializer
    implements JsonSerializer<WorkflowTemplate> {
        WorkflowTemplateSerializer() {
        }

        public JsonElement serialize(WorkflowTemplate workflowTemplate, Type arg1, JsonSerializationContext context) {
            WorkflowMetadata workflowMetadata = workflowTemplate.getMetadata();
            StringWriter strWriter = new StringWriter();
            try {
                workflowMetadata.store(strWriter, WorkflowTemplateWriter.METADATA_PROP);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            JsonObject jsonObjest = new JsonObject();
            jsonObjest.addProperty(WorkflowTemplateWriter.WRITER_VERSION_PROP, (Number)1);
            jsonObjest.addProperty(WorkflowTemplateWriter.METADATA_PROP, strWriter.toString());
            jsonObjest.add(WorkflowTemplateWriter.DEFAULT_NAME_PROP, context.serialize((Object)workflowTemplate.defaultName));
            jsonObjest.add(WorkflowTemplateWriter.STARTUP_TASK_PROP, context.serialize((Object)workflowTemplate.startUpJobDescId));
            jsonObjest.add(WorkflowTemplateWriter.TASK_LIST_PROP, context.serialize(workflowTemplate.tasksIdToJobDescId));
            jsonObjest.add(WorkflowTemplateWriter.VARIABLE_MAP_FROM_PROP, context.serialize(workflowTemplate.varMapFrom));
            jsonObjest.add(WorkflowTemplateWriter.VARIABLE_MAP_TO_PROP, context.serialize(workflowTemplate.varMapTo));
            jsonObjest.add(WorkflowTemplateWriter.CUSTOM_VALUES_PROP, context.serialize(workflowTemplate.customVariableValues));
            jsonObjest.add(WorkflowTemplateWriter.RECOMMEDATION_LIST_PROP, context.serialize(workflowTemplate.recommendationVarToSet));
            jsonObjest.add(WorkflowTemplateWriter.INPUT_LIST_PROP, context.serialize(workflowTemplate.declaredInputVar));
            jsonObjest.add(WorkflowTemplateWriter.OUTPUT_LIST_PROP, context.serialize(workflowTemplate.declaredOutputVar));
            return jsonObjest;
        }
    }
}

