/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.submissionhistory;

import com.biotechvana.javabiotoolkit.text.UTF8BufferTrimmer;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.TrackInfo;
import com.biotechvana.workflow.tracking.events.ProcessingTrackEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaskLogFile {
    static String RE = "##\\[(\\d*)\\]##(Processing|Processed|ProcessingFail)##\\[(.*)\\]";
    static Pattern PATTERN = Pattern.compile(RE, 2);
    static int MAX_BYTE_PER_BLOCK = 4096;
    public static int I_byteBufferSize = 0x200000;
    ArrayList<Object> blocks = new ArrayList();
    HashMap<String, ProcessBlock> processBlocks = new HashMap();
    SubmissionHistoryEntry entry;
    TrackInfo trackInfo;
    File logFile;
    String inCompleteLine = null;
    long prevoiusLineOffset = 0L;
    long fileByteOffset = 0L;
    StringBuilder currentBlock = new StringBuilder();
    long currentSizeByte = 0L;
    ProcessBlock currentProcessBlock;
    boolean inProcessBlock = false;
    String allLog;

    public TaskLogFile(SubmissionHistoryEntry entry, TrackInfo trackInfo, File logFile) {
        this.entry = entry;
        this.trackInfo = trackInfo;
        this.logFile = logFile;
    }

    void read() {
        if (!this.logFile.exists()) {
            return;
        }
        try {
            char c = '\n';
            StringBuilder lineBuilder = new StringBuilder();
            long cBytes = 0L;
            boolean lineStart = true;
            Charset fileCharset = Charset.defaultCharset();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.logFile, "r");
            FileChannel inFC = randomAccessFile.getChannel();
            inFC.position(this.prevoiusLineOffset);
            ByteBuffer bBuffer = ByteBuffer.allocate(I_byteBufferSize);
            while (inFC.read(bBuffer) != -1) {
                long currentLoc = inFC.position();
                bBuffer.flip();
                if (fileCharset == Charset.forName("UTF-8") && inFC.size() - inFC.position() > 0L) {
                    inFC.position(inFC.position() - (long)UTF8BufferTrimmer.endTrimUTF8Characters((ByteBuffer)bBuffer));
                }
                CharBuffer cBuffer = fileCharset.decode(bBuffer);
                bBuffer.clear();
                while (cBuffer.hasRemaining()) {
                    char previousChar = c;
                    c = cBuffer.get();
                    cBytes = fileCharset.encode(String.valueOf(c)).limit();
                    if (previousChar == '\n' || previousChar == '\r' && c != '\n') {
                        lineStart = true;
                        this.prevoiusLineOffset = this.fileByteOffset;
                    } else {
                        lineStart = false;
                    }
                    if (lineStart && lineBuilder.length() != 0) {
                        String newLine = lineBuilder.toString();
                        lineBuilder = new StringBuilder();
                        this.processLine(newLine);
                    }
                    this.fileByteOffset += cBytes;
                    lineBuilder.append(c);
                }
            }
            if (lineBuilder.length() != 0) {
                this.inCompleteLine = lineBuilder.toString();
                if (this.entry != null && !this.entry.getIsOpenForUpate()) {
                    this.processLine(this.inCompleteLine);
                }
            }
            randomAccessFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
    }

    private void processLine(String newLine) {
        if (this.check(newLine)) {
            if (this.inProcessBlock) {
                this.currentProcessBlock.setEndLine(newLine);
                this.inProcessBlock = false;
                this.currentProcessBlock.blocks.add(this.currentBlock.toString());
                this.currentBlock = new StringBuilder();
                this.currentProcessBlock = null;
            } else {
                if (this.currentBlock != null) {
                    if (this.currentBlock.length() != 0) {
                        this.blocks.add(this.currentBlock.toString());
                    }
                    this.currentBlock = null;
                }
                this.currentBlock = new StringBuilder();
                this.currentProcessBlock = new ProcessBlock();
                this.currentProcessBlock.setStartLine(newLine);
                this.blocks.add(this.currentProcessBlock);
                this.processBlocks.put(newLine.trim(), this.currentProcessBlock);
                this.inProcessBlock = true;
            }
        } else {
            this.currentBlock.append(newLine);
        }
        if (!this.inProcessBlock && this.currentBlock.length() > MAX_BYTE_PER_BLOCK) {
            this.blocks.add(this.currentBlock.toString());
            this.currentBlock = new StringBuilder();
        }
    }

    boolean check(String line) {
        Matcher matcher = PATTERN.matcher(line);
        return matcher.find();
    }

    public static void main(String[] argv) {
        TaskLogFile logFile = new TaskLogFile(null, null, new File("/home/ahafez/GPRO/ahafez/opathy.biotechvana.com/RNASeq/logs/Corset_1_1628585867.log"));
        logFile.read();
        logFile.read();
        logFile.read();
        logFile.read();
    }

    public String getLogMsg() {
        if (this.allLog == null) {
            StringBuilder builder = new StringBuilder();
            for (Object o : this.blocks) {
                builder.append(o);
            }
            if (this.entry != null && !this.entry.getIsOpenForUpate()) {
                this.allLog = builder.toString();
            } else {
                return builder.toString();
            }
        }
        return this.allLog;
    }

    public String getLogMsg(ProcessingTrackEvent startEvent) {
        if (startEvent == null) {
            return this.getLogMsg();
        }
        ProcessBlock selected = this.processBlocks.get(startEvent.getLogLine());
        if (selected != null) {
            return selected.getLogMsg();
        }
        return "No Logs Can be found for the selected Task";
    }

    class ProcessBlock {
        ArrayList<String> blocks = new ArrayList();
        String timeStamp;
        String files;
        String startLine;
        String endLine;
        int start;
        int end;
        String allLog;

        ProcessBlock() {
        }

        public void setStartLine(String newLine) {
            this.startLine = newLine.trim();
            Matcher matcher = PATTERN.matcher(this.startLine);
            matcher.find();
            this.timeStamp = matcher.group(1);
            this.files = matcher.group(3);
        }

        public void setEndLine(String newLine) {
            this.endLine = newLine;
        }

        public String toString() {
            Object rep = "";
            rep = (String)rep + "################################################\n";
            rep = (String)rep + "Running Task: Processing(" + this.files + ")\n";
            rep = (String)rep + "################################################\n\n";
            return rep;
        }

        public String getLogMsg() {
            if (this.allLog == null) {
                StringBuilder builder = new StringBuilder();
                for (String o : this.blocks) {
                    builder.append((Object)o);
                }
                if (this.endLine != null) {
                    this.allLog = builder.toString();
                } else {
                    return builder.toString();
                }
            }
            return this.allLog;
        }
    }
}

