/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.submissionhistory;

import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.submissionhistory.SubmissionHistory;
import com.biotechvana.workflow.submissionhistory.TaskLogFile;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import com.biotechvana.workflow.tracking.TrackInfo;
import com.biotechvana.workflow.tracking.tasks.TaskTracker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmissionHistoryEntry
implements Comparable<SubmissionHistoryEntry> {
    static final Logger LOGGER = LoggerFactory.getLogger(SubmissionHistoryEntry.class);
    private transient SubmissionHistory submissionHistory;
    private long submissionTimeStamp;
    private String taskName;
    private String scriptFilePath;
    private String scriptFolderPath;
    private TaskType taskType;
    private ExecStatus status = ExecStatus.Unknown;
    String trackFileName;
    String logFileName;
    private String taskTemplateId;
    String softWareName;
    private boolean isOpenForUpadate = true;
    private transient TrackInfo trackerInfo;
    transient WorkflowJob workflowjobInstance;
    transient TaskTracker tracker;

    public SubmissionHistory getSubmissionHistory() {
        return this.submissionHistory;
    }

    public void setSubmissionHistory(SubmissionHistory userHist) {
        this.submissionHistory = userHist;
    }

    public void setSumbissionTimeStamp(long value) {
        this.submissionTimeStamp = value;
    }

    public long getSubmissionTimeStamp() {
        return this.submissionTimeStamp;
    }

    public void setTaskName(String value) {
        this.taskName = value;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setScriptFilePath(String value) {
        this.scriptFilePath = value;
    }

    public String getScriptFilePath() {
        return this.scriptFilePath;
    }

    public void setScriptFolderPath(String value) {
        this.scriptFolderPath = value;
    }

    public String getScriptFolderPath() {
        return FilenameUtils.normalize((String)this.scriptFolderPath, (boolean)true);
    }

    public void setTaskType(String value) {
        this.taskType = value.trim().equals("w") ? TaskType.Pipeline : TaskType.Job;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public ExecStatus getStatus() {
        if (this.trackerInfo != null) {
            this.status = this.trackerInfo.getExecStatus();
        }
        return this.status;
    }

    public SubmissionHistoryEntry(SubmissionHistory submissionHistory, long submissionTimestamp, String taskCustomName, String scriptFilePath, String scriptFolderPath, String scriptType, String softwareName, String taskTemplateID) {
        this.setScriptFilePath(scriptFilePath);
        this.setScriptFolderPath(scriptFolderPath);
        this.setTaskName(taskCustomName);
        this.setSumbissionTimeStamp(submissionTimestamp);
        this.setTaskType(scriptType);
        this.setSoftwareName(softwareName);
        this.setTaskTemplateID(taskTemplateID);
        this.submissionHistory = submissionHistory;
        this.trackFileName = this.taskName + "_" + this.submissionTimeStamp + ".track";
        this.logFileName = this.taskName + "_" + this.submissionTimeStamp + ".log";
    }

    private void setTaskTemplateID(String taskID) {
        this.taskTemplateId = taskID;
    }

    private void setSoftwareName(String softwareName) {
        this.softWareName = softwareName;
    }

    public boolean getIsOpenForUpate() {
        return this.isOpenForUpadate;
    }

    public void setIsOpenForUpadate(boolean isOpenForUpadate) {
        this.isOpenForUpadate = isOpenForUpadate;
    }

    private void setTrackerInfo(TrackInfo tInfo) {
        this.trackerInfo = tInfo;
    }

    public TrackInfo getTrackInfo() {
        return this.trackerInfo;
    }

    public int hashCode() {
        return (int)(this.submissionTimeStamp * 10L + (long)this.taskName.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj instanceof SubmissionHistoryEntry) {
            SubmissionHistoryEntry e2 = (SubmissionHistoryEntry)obj;
            if (e2 == null) {
                return false;
            }
            if (this.submissionTimeStamp == e2.submissionTimeStamp && this.taskName.equals(e2.taskName)) {
                return true;
            }
        }
        return false;
    }

    public String getSubmissionTime() {
        return new SimpleDateFormat("dd-MM-YYYY  HH:mm:ss").format(new Date(this.submissionTimeStamp * 1000L));
    }

    public String getFinishTime() {
        long finishTime = -1L;
        if (this.trackerInfo == null) {
            this.updateTrack();
        }
        if (this.trackerInfo != null) {
            finishTime = this.trackerInfo.getStopTime();
        }
        if (finishTime == -1L) {
            return "";
        }
        return new SimpleDateFormat("dd-MM-YYYY  HH:mm:ss").format(new Date(finishTime * 1000L));
    }

    @Override
    public int compareTo(SubmissionHistoryEntry o) {
        return Long.compare(this.submissionTimeStamp, o.submissionTimeStamp);
    }

    public void updateTrack() {
        ExecStatus lastStatus = this.getStatus();
        File trackFolderPath = this.submissionHistory.getUserManager().getLocalPathManager().getTrackFolder();
        File trackFile = new File(trackFolderPath, this.trackFileName);
        TrackInfo tInfo = TrackInfo.loadFromFile_nested(trackFile);
        this.setTrackerInfo(tInfo);
        if (this.getTaskType() == TaskType.Job) {
            String logMsg = "No log could be found for this Job.";
            File logFile = new File(this.submissionHistory.getUserManager().getLocalPathManager().getLogFolder(), this.logFileName);
            try {
                FileReader rd = new FileReader(logFile);
                logMsg = IOUtils.toString((Reader)rd);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                logMsg = "Log File is to large to view";
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            tInfo.setLogMsg(logMsg);
            if (tInfo.getTaskLog() == null) {
                TaskLogFile taskLogFile = new TaskLogFile(this, tInfo, logFile);
                taskLogFile.read();
                tInfo.setTaskLog(taskLogFile);
            } else {
                tInfo.getTaskLog().read();
            }
        } else {
            FileReader rd;
            String trackFolderName = this.getTaskName() + "_" + this.getSubmissionTimeStamp();
            String logMsg = "No log could be found.";
            File logFolder = new File(this.submissionHistory.getUserManager().getLocalPathManager().getLogFolder(), trackFolderName);
            File logFile = new File(logFolder, tInfo.getTaskName() + "_log");
            try {
                rd = new FileReader(logFile);
                logMsg = IOUtils.toString((Reader)rd);
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Can not find log file " + String.valueOf(logFile));
                e.printStackTrace();
            }
            catch (IOException e) {
                LOGGER.warn("Can not find log file " + String.valueOf(logFile));
                e.printStackTrace();
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                logMsg = "Log File is to large to view";
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            tInfo.setLogMsg(logMsg);
            for (ITrackerInfo info : tInfo.getTrackerInfoEntries()) {
                String sublogMsg = "No logs could be found for this task.";
                if (info instanceof TrackInfo) {
                    File logFolder2 = new File(this.submissionHistory.getUserManager().getLocalPathManager().getLogFolder(), trackFolderName);
                    File logFile2 = new File(logFolder2, info.getTaskName() + "_log");
                    try {
                        rd = new FileReader(logFile2);
                        sublogMsg = IOUtils.toString((Reader)rd);
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.warn("Can not find log file " + String.valueOf(logFile2));
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Can not find log file " + String.valueOf(logFile2));
                        e.printStackTrace();
                    }
                    catch (OutOfMemoryError e) {
                        e.printStackTrace();
                        sublogMsg = "Log File is to large to view";
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                info.setLogMsg(sublogMsg);
            }
        }
        this.initTaskTracker();
    }

    private void initTaskTracker() {
        if (this.getTaskType() == TaskType.Job) {
            try {
                this.workflowjobInstance = this.submissionHistory.getSubmissionHistoryManager().createJobInstance(this);
                this.tracker = TaskTracker.toTaskTracker(this.workflowjobInstance, this);
                this.setTracker(this.tracker);
            }
            catch (Exception e) {
                LOGGER.debug("Can not init TaskTracker for " + String.valueOf(this), (Throwable)e);
            }
        }
    }

    public String getLastTimeUpdated() {
        long lastTime = -1L;
        if (this.trackerInfo == null) {
            this.updateTrack();
        }
        if (this.trackerInfo != null) {
            lastTime = this.trackerInfo.getLastTimeUpdated();
        }
        if (lastTime == -1L) {
            return "";
        }
        return new SimpleDateFormat("dd-MM-YYYY  HH:mm:ss").format(new Date(lastTime * 1000L));
    }

    public String getTaskTemplateId() {
        return this.taskTemplateId;
    }

    public String getTaskInternalId() {
        if (this.trackerInfo != null) {
            return this.trackerInfo.getTaskName();
        }
        return this.taskTemplateId;
    }

    public void setTest() {
        this.trackerInfo.setTest();
    }

    public boolean isNotRunning() {
        return this.getStatus() == ExecStatus.Warning || this.getStatus() == ExecStatus.Failed || this.getStatus() == ExecStatus.Finished || this.getStatus() == ExecStatus.Unknown || this.getStatus() == ExecStatus.Canceled;
    }

    public boolean isSucceed() {
        return this.getStatus() == ExecStatus.Warning || this.getStatus() == ExecStatus.Finished;
    }

    public boolean isRunning() {
        return this.getStatus() == ExecStatus.Running;
    }

    public boolean isPaused() {
        return this.getStatus() == ExecStatus.Paused;
    }

    public File getTrackFile() {
        File trackFolderPath = this.submissionHistory.getUserManager().getLocalPathManager().getTrackFolder();
        String trackFileName = this.taskName + "_" + this.submissionTimeStamp + ".track";
        File trackFile = new File(trackFolderPath, trackFileName);
        return trackFile;
    }

    public String getIdentifier() {
        return this.taskName + "_" + this.submissionTimeStamp;
    }

    public void setTracker(TaskTracker tracker) {
        this.tracker = tracker;
    }

    public TaskTracker getTracker() {
        if (this.tracker == null) {
            this.initTaskTracker();
        }
        return this.tracker;
    }

    public String toString() {
        return "Entry : " + this.getSubmissionTime() + "," + this.getTaskName();
    }

    public static enum TaskType {
        Pipeline,
        Job;

    }
}

