/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.submissionhistory;

import com.biotechvana.users.UserManager;
import com.biotechvana.workflow.SubmissionHistoryManager;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class SubmissionHistory {
    transient SubmissionHistoryManager submissionHistoryManager;
    transient UserManager userManager;
    private TreeSet<SubmissionHistoryEntry> submissionHistoryEntries;
    private long lastTimeSync;

    public Set<SubmissionHistoryEntry> getSubmissionHistoryEntries() {
        if (this.submissionHistoryEntries == null) {
            this.submissionHistoryEntries = new TreeSet(Comparator.reverseOrder());
        }
        return this.submissionHistoryEntries;
    }

    public SubmissionHistory(SubmissionHistoryManager submissionHistoryManager) {
        this.setSubmissionHistoryManager(submissionHistoryManager);
    }

    public void setSubmissionHistoryManager(SubmissionHistoryManager submissionHistoryManager) {
        this.submissionHistoryManager = submissionHistoryManager;
        this.userManager = submissionHistoryManager.getUserManager();
    }

    public SubmissionHistoryManager getSubmissionHistoryManager() {
        return this.submissionHistoryManager;
    }

    public UserManager getUserManager() {
        return this.submissionHistoryManager.getUserManager();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateEntries(boolean localOnly) {
        currentUserPath = this.userManager.getLocalPathManager().getModuleFolder();
        userHistFile = null;
        userHistFile = new File(currentUserPath, "/hist.hist");
        if (!userHistFile.exists()) {
            System.out.println("userHistFile does not exist " + String.valueOf(userHistFile));
            return;
        }
        this.getSubmissionHistoryEntries();
        try {
            br = new BufferedReader(new FileReader(userHistFile));
            try {
                while (true) {
                    block10: {
                        if ((line = br.readLine()) != null) break block10;
                        var7_11 = this.submissionHistoryEntries.iterator();
                        ** GOTO lbl49
                    }
                    try {
                        line = line.trim();
                        if (line.isEmpty()) continue;
                        tokens = line.split(";");
                        submitDateIndex = 0;
                        taskNameIndex = 1;
                        scriptFileIndex = 2;
                        scriptFolderIndex = 3;
                        taskTypeIndex = 4;
                        softwareNameIndex = 5;
                        taskIdIndex = 6;
                        submitDate = tokens[submitDateIndex];
                        taskName = tokens[taskNameIndex];
                        scriptFile = tokens[scriptFileIndex];
                        scriptFolder = tokens[scriptFolderIndex];
                        taskType = tokens[taskTypeIndex];
                        softwareName = tokens[softwareNameIndex];
                        taskID = "";
                        if (taskIdIndex < tokens.length) {
                            taskID = tokens[taskIdIndex];
                        }
                        if (!this.submissionHistoryEntries.add(entry = new SubmissionHistoryEntry(this, Long.parseLong(submitDate), taskName, scriptFile, scriptFolder, taskType, softwareName, taskID))) continue;
                        entry.updateTrack();
                        if (!entry.isNotRunning() || entry.getStatus() == ExecStatus.Unknown) continue;
                        entry.setIsOpenForUpadate(false);
                    }
                    catch (Exception ex) {
                        System.err.println("Error parsing history line " + line);
                    }
                }
            }
            catch (IOException e) {
                System.out.println(e);
                e.printStackTrace();
                return;
lbl49:
                // 1 sources

                if (true) ** GOTO lbl62
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return;
        do {
            entry = var7_11.next();
            if (localOnly || !entry.getIsOpenForUpate()) continue;
            this.submissionHistoryManager.downloadLogFile(entry);
            this.submissionHistoryManager.downloadTrackFile(entry);
            entry.updateTrack();
            if (!entry.isNotRunning() || entry.getStatus() == ExecStatus.Unknown) continue;
            entry.setIsOpenForUpadate(false);
lbl62:
            // 4 sources

        } while (var7_11.hasNext());
        br.close();
    }

    public void setlastTimeUpdates(long remoteFileLastTimeModifed) {
        this.lastTimeSync = remoteFileLastTimeModifed;
    }

    public long getLastTimeUpdated() {
        return this.lastTimeSync;
    }

    public void delete(SubmissionHistoryEntry entry) {
        this.submissionHistoryManager.deleteEntry(entry);
        this.submissionHistoryEntries.remove(entry);
        this.submissionHistoryManager.saveUserHistoryToDisk();
    }

    public void pasue(SubmissionHistoryEntry entry) {
        this.submissionHistoryManager.pasueEntry(entry);
    }

    public void resume(SubmissionHistoryEntry entry) {
        this.submissionHistoryManager.resumeEntry(entry);
    }

    public void stop(SubmissionHistoryEntry entry) {
        this.submissionHistoryManager.stopEntry(entry);
    }

    public void delete(ArrayList<SubmissionHistoryEntry> entries) {
        this.submissionHistoryManager.deleteEntry(entries);
        this.submissionHistoryEntries.removeAll(entries);
        this.submissionHistoryManager.saveUserHistoryToDisk();
    }

    public SubmissionHistoryEntry getEntry(String entryId) {
        for (SubmissionHistoryEntry entry : this.submissionHistoryEntries) {
            if (!entry.getTaskName().equals(entryId)) continue;
            return entry;
        }
        return null;
    }
}

