/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.manager;

import com.biotechvana.utils.WorkspaceUtils;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import com.biotechvana.workflow.configuration.SimpleWorkflowConfiguration;
import com.biotechvana.workflow.manager.PipelinesCreatorHelper;
import com.biotechvana.workflow.manager.WorkflowManager;
import com.biotechvana.workflow.template.WorkflowTemplate;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public abstract class WorkflowCatalog {
    protected HashMap<String, Class> configurationImlps = new HashMap();
    protected HashMap<String, Class> configurationImlpsWizard = new HashMap();
    private ArrayList<WorkflowTemplate> workflowTemplates = new ArrayList();
    private ArrayList<Workflow> localSavedWorkflows = new ArrayList();
    private ArrayList<IPipelineConfiguration> localSavedExperimentConfiguration = new ArrayList();
    boolean outOfSync = true;
    protected WorkflowManager workflowManager;

    protected WorkflowCatalog() {
    }

    public void setup() {
        this.workflowTemplates.clear();
        this.initCatalog();
        this.configurationImlps.clear();
        this.configurationImlps.put(WorkflowStartupJob.class.getName(), SimpleWorkflowConfiguration.class);
        this.setConfigurationImlp();
    }

    protected abstract void initCatalog();

    protected abstract void setConfigurationImlp();

    protected void addConfigurationImlp(Class startupJobClass, Class clazz) {
        this.configurationImlps.put(startupJobClass.getName(), clazz);
    }

    protected void addConfigurationImlpWizard(Class configurationImlp, Class configurationImlpWizard) {
        this.configurationImlpsWizard.put(configurationImlp.getName(), configurationImlpWizard);
    }

    protected void addConfigurationImlp(Class startupJobClass, Class configurationImlp, Class configurationImlpWizard) {
        this.configurationImlps.put(startupJobClass.getName(), configurationImlp);
        this.configurationImlpsWizard.put(configurationImlp.getName(), configurationImlpWizard);
    }

    public void addtemplateWorkflow(WorkflowTemplate wf_temp) {
        this.workflowTemplates.add(wf_temp);
    }

    public ArrayList<WorkflowTemplate> getWorkflowTemplates() {
        return this.workflowTemplates;
    }

    public WorkflowTemplate[] getWorkflowTemplatesAsArray() {
        return this.workflowTemplates.toArray(new WorkflowTemplate[this.workflowTemplates.size()]);
    }

    public WorkflowTemplate getTemplateByID(String templateId) {
        for (WorkflowTemplate wf : this.workflowTemplates) {
            if (!wf.getTemplateId().equals(templateId)) continue;
            return wf;
        }
        return null;
    }

    public void clear() {
        this.outOfSync = true;
        this.localSavedExperimentConfiguration.clear();
        this.localSavedWorkflows.clear();
    }

    private void syncWithServer() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Please Wait While Syncing projects with the server.", -1);
                WorkflowCatalog.this.workflowManager.getPipelinesCreatorHelper().syncProjects();
            }
        };
        try {
            new ProgressMonitorDialog(WorkspaceUtils.getShell()).run(true, false, runnable);
        }
        catch (InvocationTargetException ev) {
            ev.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private void loadAllSaved() {
        File[] projectsFiles;
        File pipelinesFolder = this.workflowManager.getPipelinesCreatorHelper().getUserPipelinesFolder();
        File[] fileArray = projectsFiles = pipelinesFolder.listFiles();
        int n = projectsFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File projectFile = fileArray[n2];
            System.out.println(projectFile);
            this.workflowManager.getPipelinesCreatorHelper();
            Workflow workflow = PipelinesCreatorHelper.loadPipelineFromFile(this.workflowManager, projectFile);
            if (workflow != null) {
                this.getLocalSavedWorkflows().add(workflow);
            }
            ++n2;
        }
        File projectsFolder = this.workflowManager.getPipelinesCreatorHelper().getUserProjectsFolder();
        File[] fileArray2 = projectsFiles = projectsFolder.listFiles();
        int n3 = projectsFiles.length;
        n = 0;
        while (n < n3) {
            File projectFile = fileArray2[n];
            IPipelineConfiguration savedPipelineConfig = PipelinesCreatorHelper.loadProjectFromFile(projectFile, this.configurationImlps.values());
            if (savedPipelineConfig != null) {
                WorkflowTemplate wf;
                savedPipelineConfig.setWorkflowManager(this.workflowManager);
                Workflow pipeline = this.getSavedPipelineByID(savedPipelineConfig.getPipelineId());
                if (pipeline == null && (pipeline = (wf = this.getTemplateByID(savedPipelineConfig.getWorkflowTemplateId())).createWorkflow(this.workflowManager)) != null) {
                    pipeline = this.createPiplineFromTemplate(savedPipelineConfig.getWorkflowTemplateId(), savedPipelineConfig.getPojectName());
                }
                if (pipeline != null) {
                    savedPipelineConfig.setPipeline(pipeline);
                }
                this.getLocalSavedExperimentConfiguration().add(savedPipelineConfig);
            }
            ++n;
        }
    }

    public static ArrayList<Workflow> filterWorkflowsByHasTag(ArrayList<Workflow> list, String[] tags, boolean contain) {
        ArrayList<Workflow> filtered = new ArrayList<Workflow>();
        for (Workflow w : list) {
            boolean add = true;
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (!tag.isEmpty() && !w.getMetadata().hasTag(tag) == contain) {
                    add = false;
                }
                ++n2;
            }
            if (!add) continue;
            filtered.add(w);
        }
        return filtered;
    }

    public static ArrayList<WorkflowTemplate> filterTemplatesByHasTag(List<WorkflowTemplate> list, String[] tags, boolean contain, boolean or) {
        ArrayList<WorkflowTemplate> filtered = new ArrayList<WorkflowTemplate>();
        for (WorkflowTemplate w : list) {
            boolean add = false;
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (!tag.isEmpty()) {
                    boolean ifTrue;
                    boolean bl = ifTrue = w.getMetadata().hasTag(tag) == contain;
                    if (!ifTrue && !or) {
                        add = false;
                        break;
                    }
                    if (ifTrue && or) {
                        add = true;
                        break;
                    }
                    if (ifTrue && !or) {
                        add = true;
                    }
                    if (!ifTrue) {
                        // empty if block
                    }
                }
                ++n2;
            }
            if (!add) continue;
            filtered.add(w);
        }
        return filtered;
    }

    @Deprecated
    public static Workflow createPiplineFromTemplate(Workflow workflow) throws IllegalArgumentException {
        Workflow newCreatedWf = workflow.createClone();
        if (newCreatedWf == null) {
            throw new IllegalArgumentException("Trying to create a workflow from a non template workflow.");
        }
        WorkflowCatalog.assignNewID(newCreatedWf);
        return newCreatedWf;
    }

    public Workflow createPiplineFromTemplate(String templateId, String projectName) throws IllegalArgumentException {
        Workflow newCreatedWf = null;
        for (WorkflowTemplate wf : this.workflowTemplates) {
            if (!wf.getMetadata().getTemplateId().equals(templateId)) continue;
            newCreatedWf = wf.createWorkflow(this.workflowManager);
            break;
        }
        if (newCreatedWf == null) {
            throw new IllegalArgumentException("Trying to create a workflow from a non template workflow.");
        }
        newCreatedWf.setWorkflowName(projectName);
        WorkflowCatalog.assignNewID(newCreatedWf);
        return newCreatedWf;
    }

    private static void assignNewID(Workflow workflow) {
        String newId = workflow.getWorkflowName() + "_" + workflow.getWorkflowId();
        workflow.setWorkflowId(newId);
    }

    public static void fixGeneratedID(Workflow workflow) {
        String fixedId = workflow.getWorkflowName() + "_" + workflow.getMetadata().getTemplateId();
        workflow.setWorkflowId(fixedId);
    }

    public boolean checkExperimentConfigurationName(IPipelineConfiguration experimentConfiguration) {
        String checkName = experimentConfiguration.getPojectName();
        for (IPipelineConfiguration expConfig : this.getLocalSavedExperimentConfiguration()) {
            if (!expConfig.getPojectName().equals(checkName)) continue;
            return false;
        }
        return true;
    }

    public void addProject(IPipelineConfiguration experimentConfiguration) {
        this.getLocalSavedExperimentConfiguration().add(experimentConfiguration);
    }

    public Workflow getExpPipelineByID(String taskID) {
        for (IPipelineConfiguration iPipelineConfiguration : this.getLocalSavedExperimentConfiguration()) {
            if (iPipelineConfiguration.getWorkflow() == null || !iPipelineConfiguration.getWorkflow().getWorkflowId().equals(taskID)) continue;
            return iPipelineConfiguration.getWorkflow();
        }
        for (Workflow workflow : this.getLocalSavedWorkflows()) {
            if (!workflow.getWorkflowId().equals(taskID)) continue;
            return workflow;
        }
        for (WorkflowTemplate workflowTemplate : this.workflowTemplates) {
            if (!taskID.contains("_" + workflowTemplate.getTemplateId())) continue;
            return workflowTemplate.createWorkflow(this.workflowManager);
        }
        return null;
    }

    public void removeSavedPipelineConfiguration(String projectName) {
        IPipelineConfiguration selected = this.getPipelineConfigurationByPipelineName(projectName);
        if (selected != null) {
            this.getLocalSavedExperimentConfiguration().remove(selected);
        }
    }

    public Workflow getSavedPipelineByID(String taskID) {
        for (Workflow wf : this.getLocalSavedWorkflows()) {
            if (!wf.getWorkflowId().equals(taskID)) continue;
            return wf;
        }
        return null;
    }

    public IPipelineConfiguration getPipelineConfigurationByTaskId(String taskID) {
        for (IPipelineConfiguration wf : this.getLocalSavedExperimentConfiguration()) {
            if (!wf.getPojectName().equals(taskID)) continue;
            return wf;
        }
        return null;
    }

    public IPipelineConfiguration getPipelineConfigurationByPipelineName(String taskID) {
        for (IPipelineConfiguration wf : this.getLocalSavedExperimentConfiguration()) {
            if (!wf.getPojectName().equals(taskID)) continue;
            return wf;
        }
        return null;
    }

    private ArrayList<IPipelineConfiguration> getLocalSavedExperimentConfiguration() {
        if (this.outOfSync) {
            this.syncWithServer();
            this.outOfSync = false;
            this.loadAllSaved();
        }
        return this.localSavedExperimentConfiguration;
    }

    private void setLocalSavedExperimentConfiguration(ArrayList<IPipelineConfiguration> localSavedExperimentConfiguration) {
        this.localSavedExperimentConfiguration = localSavedExperimentConfiguration;
    }

    private ArrayList<Workflow> getLocalSavedWorkflows() {
        if (this.outOfSync) {
            this.syncWithServer();
            this.outOfSync = false;
            this.loadAllSaved();
        }
        return this.localSavedWorkflows;
    }

    private void setLocalSavedWorkflows(ArrayList<Workflow> localSavedWorkflows) {
        this.localSavedWorkflows = localSavedWorkflows;
    }

    public void setWorkflowManager(WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
        this.setup();
    }

    public Class getConfigurationImlpsClass(String startupJobClassName) {
        return this.configurationImlps.get(startupJobClassName);
    }

    public Class getConfigurationWizardClass(Class configurationimplClazz) {
        Class clazz = this.configurationImlpsWizard.get(configurationimplClazz.getName());
        if (clazz == null) {
            Class superClazz = configurationimplClazz.getSuperclass();
            if (superClazz == null) {
                return null;
            }
            return this.getConfigurationWizardClass(superClazz);
        }
        return clazz;
    }
}

