/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.executer;

import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.executer.BashBackgrounBlock;
import com.biotechvana.workflow.executer.BashBlock;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.executer.BashStatement;
import com.biotechvana.workflow.executer.CMLTemplate;
import com.biotechvana.workflow.executer.IFObject;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;

public class BashProcessBlock
extends BashBlock {
    String iterVar = "_i";
    private FileVariable input;
    CMLTemplate cmdTemplate;
    BashBlock after;
    BashBlock before;
    private boolean isParallel = true;
    private boolean batchMode = true;
    String condtionalVar = null;
    boolean checkInput = false;
    boolean failOnCheckInput = false;

    public BashProcessBlock(CMLTemplate cmdTemplate) {
        this.cmdTemplate = cmdTemplate;
        cmdTemplate.setBatchMode(this.batchMode);
        this.after = new BashBlock();
        this.before = new BashBlock();
        this.internalIndetLevels = 0;
    }

    public void addAfter(BashStatement command) {
        this.after.addStatment(command);
    }

    public void addBefore(String st) {
        this.before.addStatment(st);
    }

    public void setInputVariable(FileVariable input) {
        this.input = input;
    }

    public void setParallel(boolean b) {
        this.isParallel = b;
    }

    @Override
    public void generate(StringBuilder builder) {
        String indent = this.getIndent();
        String inVar1 = "_inputFile1";
        String inVar2 = "_inputFile2";
        String inVar1BaseName = "inputFile1BaseName";
        String inVar2BaseName = "inputFile2BaseName";
        String statusVar = this.cmdTemplate.getTaskStatusVarName();
        String shmFolder = String.format("/dev/shm/${%s}", Tracking.SCRIPT_ID_VARNAME);
        String shmPattern = String.format("%s/%s_%s", shmFolder, this.cmdTemplate.getTaskCleanName(), BashProcessBlock.$(this.iterVar));
        BashBackgrounBlock bg = new BashBackgrounBlock();
        bg.addStatment(BashProcessBlock.st(String.format("trap \"ReturnStatus ${%s}\" EXIT", this.cmdTemplate.getProcessShmExitCodeVarName())));
        bg.addStatment(this.before);
        bg.addStatment(this.cmdTemplate);
        bg.addStatment(this.after);
        BashStatement innerLogic = bg;
        if (this.checkInput) {
            IFObject ifStatment = new IFObject(BashConditions.fileExist(BashProcessBlock.$(inVar1)));
            ifStatment.thenBlock.addStatment(bg);
            innerLogic = ifStatment;
        }
        Object initSts = "";
        if (this.input instanceof FilesVariable) {
            this.cmdTemplate.filesToTrackVarName = inVar1;
            initSts = (String)initSts + BashProcessBlock.st(BashHelper.assign(inVar1, this.input.$("$_i"))) + BashProcessBlock.st(BashHelper.assign(inVar1BaseName, BashHelper.getBaseName(inVar1)));
        }
        if (this.input instanceof FileListVariable) {
            initSts = (String)initSts + BashProcessBlock.st(BashHelper.assign(inVar1, this.input.$("0,$_i"))) + BashProcessBlock.st(BashHelper.assign(inVar2, this.input.$("1,$_i"))) + BashProcessBlock.st(BashHelper.assign(inVar1BaseName, BashHelper.getBaseName(inVar1))) + BashProcessBlock.st(BashHelper.assign(inVar2BaseName, BashHelper.getBaseName(inVar2)));
        }
        builder.append(BashProcessBlock.st("mkdir " + shmFolder));
        builder.append(Tracking.trackProcessTrack(this.input));
        builder.append(BashHelper.forIndex(this.iterVar, this.input.getCountAsBashVarName(), "_i++", (String)initSts + BashProcessBlock.st(BashHelper.assign(bg.getCommandIdVarName(), String.format("%s_%s_%s", BashProcessBlock.$(Tracking.SCRIPT_ID_VARNAME), this.cmdTemplate.getTaskCleanName(), BashProcessBlock.$(this.iterVar)))) + BashProcessBlock.st(BashHelper.assign(this.cmdTemplate.getProcessShmExitCodeVarName(), shmPattern)) + "\n" + innerLogic.toString() + "\n"));
        builder.append(BashProcessBlock.st("wait"));
        if (this.batchMode) {
            builder.append(BashProcessBlock.st(BashHelper.assign(this.cmdTemplate.getFinalTaskStatusVarName(), "true")));
            builder.append(BashHelper.forIndex(this.iterVar, this.input.getCountAsBashVarName(), "_i++", BashProcessBlock.st("[ -f " + shmPattern + " ] && let retVal=$(<" + shmPattern + ")") + BashProcessBlock.st(BashHelper.assign(this.I(statusVar, BashProcessBlock.$(this.iterVar)), BashProcessBlock.$("retVal"))) + BashProcessBlock.st("[ $retVal -ne 0 ] &&  " + BashHelper.assign(this.cmdTemplate.getFinalTaskStatusVarName(), "false"))));
        }
        builder.append(BashProcessBlock.st("rm -r " + shmFolder));
    }

    public void conditionalOn(BashProcessBlock process) {
        this.condtionalVar = process.cmdTemplate.getFinalTaskStatusVarName();
    }

    public void checkInputExist(boolean checkInput) {
        this.checkInput = checkInput;
    }

    public void checkInputExist(boolean checkInput, boolean failOnCheckInput) {
        this.checkInput = checkInput;
        this.failOnCheckInput = failOnCheckInput;
    }
}

