/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.executer;

import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.executer.IFObject;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class BashHelper {
    private static final String EMPTY_BLOCK = ":\n";
    public static String semaphoreVar = "semaphoreVar";
    public static String SCREEN_LOG_LOCK_HANDLER = "SCREEN_LOG_LOCK_HANDLER";
    public static String SCREEN_LOG_LOCK_FILENAME = "SCREEN_LOG_LOCK_FILENAME";
    public static String USER_MAX_NUM_PROCESS_VAR = "max_num_process";

    public static IFObject If(String cond) {
        IFObject r = new IFObject(cond);
        return r;
    }

    public static String IF(String cond, String then) {
        then = BashHelper.addIndenet(then);
        cond = cond.trim();
        String sperator = " ";
        if (cond.charAt(0) == '[') {
            sperator = "";
        }
        String cmd = "\nif [" + sperator + cond + sperator + "]; \nthen\n" + then + " \nfi\n";
        return cmd;
    }

    public static String IF(String cond, String then, String elseBody) {
        then = BashHelper.addIndenet(then);
        elseBody = BashHelper.addIndenet(elseBody);
        cond = cond.trim();
        String sperator = " ";
        if (cond.charAt(0) == '[') {
            sperator = "";
        }
        String cmd = "\nif [" + sperator + cond + sperator + "]; \nthen\n" + then + "\nelse\n" + elseBody + " \nfi\n";
        return cmd;
    }

    public static String forEachValue(String iterVar, String bashVarName, String forBody) {
        String cmd = "\n\nfor " + iterVar + " in " + bashVarName + "; do \n" + BashHelper.addIndenet(forBody) + "\ndone\n\n";
        return cmd;
    }

    public static String forEachIndex(String iterVar, String bashVarName, String forBody) {
        String cmd = "\n\nfor " + iterVar + " in \"${!" + bashVarName + "[@]}\"; do \n" + BashHelper.addIndenet(forBody) + "\ndone\n\n";
        return cmd;
    }

    public static String forIndex(String iterVar, String bashCountVar, String step, String forBody) {
        String cmd = "\n\nfor ((" + iterVar + "=0;" + iterVar + "<" + bashCountVar + ";" + step + ")) do \n" + BashHelper.addIndenet(forBody) + "\ndone\n\n";
        return cmd;
    }

    public static String forIndex(String iterVar, String initValue, String bashCountVar, String step, String forBody) {
        String cmd = "\n\nfor ((" + iterVar + "=" + initValue + ";" + iterVar + "<" + bashCountVar + ";" + step + ")) do \n" + BashHelper.addIndenet(forBody) + "\ndone\n\n";
        return cmd;
    }

    public static String BLOCK_groupArray(String arrayVarName, String resVarName, String sep) {
        String res = resVarName + "=\"\"\n";
        res = res + BashHelper.forEachValue("_oneItemName", "${" + arrayVarName + "[@]}", resVarName + "=\"${" + resVarName + "}" + sep + "${_oneItemName}\"");
        if (!sep.isEmpty()) {
            res = res + resVarName + "=\"${" + resVarName + ":1}\"\n\n\n";
        }
        return res;
    }

    public static String getBaseName(String varName) {
        return "$(basename ${" + varName + "%.*}  )";
    }

    public static String getBaseName(String varName, String ext) {
        return "$(basename ${" + varName + "}  " + ext + " )";
    }

    public static String getExt(String varName) {
        return "$(rev <<< \"${" + varName + "}\" | cut -d. -f1 | rev)";
    }

    public static String getExt(JobVariable var) {
        return "$(rev <<< \"${" + var.getBashVarName() + "}\" | cut -d. -f1 | rev)";
    }

    public static String getBaseName(JobVariable var) {
        return "$(basename ${" + var.getBashVarName() + "%.*} )";
    }

    public static String getBaseName(JobVariable var, String index) {
        return "$(basename ${" + var.getBashVarName(index) + "%.*} )";
    }

    public static String getDirName(JobVariable var) {
        return "$(dirname ${" + var.getBashVarName() + "} )";
    }

    public static String moveWithWarning(String oldFileName, String newFileName) {
        return "\n[ -f \"" + oldFileName + "\" ] && mv  \"" + oldFileName + "\"  \"" + newFileName + "\"  || { " + Tracking.trackLogWarning(oldFileName + "   Does not Exist") + " \n}\n";
    }

    public static String Batcher(FilesVariable filesVariable, String customTemplateStart, String customTemplateCommand, String customTemplateEnd) {
        Object template = Tracking.trackProcessTrack(filesVariable);
        String inVar = "_inputFile";
        String inVarBaseName = "inputFileBaseName";
        template = (String)template + BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", inVar + "=\"" + filesVariable.$("$_i") + "\"\n" + inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\n" + customTemplateStart + "\n" + Tracking.trackProcessing("${_inputFile}") + "echo \"Processing : ${_inputFile}\" \n{\n" + customTemplateCommand + "\n} && ( " + Tracking.trackProcessed("${_inputFile}") + " ) || ( " + Tracking.trackProcessedFail("${_inputFile}") + " ) \n" + customTemplateEnd);
        return template;
    }

    public static String Batcher_noLog(FilesVariable filesVariable, String customTemplateCommand, boolean silent) {
        String inVar = "_inputFile";
        String inVarBaseName = "inputFileBaseName";
        String echoMsg = "";
        if (!silent) {
            echoMsg = "echo \"Processing : ${_inputFile}\" \n";
        }
        String template = BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", inVar + "=\"" + filesVariable.$("$_i") + "\"\n" + inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\n" + echoMsg + customTemplateCommand);
        return template;
    }

    public static String Batcher(FileListVariable filesVariable, String customTemplateStart, String customTemplate1, String customTemplate2, String customTemplateEnd) {
        String inVar1 = "_inputFile1";
        String inVar2 = "_inputFile2";
        String inVar1BaseName = "inputFile1BaseName";
        String inVar2BaseName = "inputFile2BaseName";
        if (customTemplate1 == null || customTemplate1.isEmpty()) {
            customTemplate1 = EMPTY_BLOCK;
        }
        if (customTemplate2 == null || customTemplate2.isEmpty()) {
            customTemplate2 = EMPTY_BLOCK;
        }
        Object template = Tracking.trackProcessTrack(filesVariable);
        template = (String)template + BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", inVar1 + "=\"" + filesVariable.$("0,$_i") + "\"\n" + inVar2 + "=\"" + filesVariable.$("1,$_i") + "\"\n" + inVar1BaseName + "=" + BashHelper.getBaseName("_inputFile1") + "\n__tempInFile=\"${_inputFile1}\"\n" + customTemplateStart + "\n" + BashHelper.IF("-n \"${" + inVar2 + "}\"", inVar2BaseName + "=" + BashHelper.getBaseName("_inputFile2") + "\n__tempInFile=\"${__tempInFile} , ${_inputFile2}\"\n" + Tracking.trackProcessing("${__tempInFile}") + "echo \"Processing : ${__tempInFile}\" \n{\n" + customTemplate2 + "\n\n} && ( " + Tracking.trackProcessed("${__tempInFile}") + " ) || ( " + Tracking.trackProcessedFail("${__tempInFile}") + " ) ", Tracking.trackProcessing("${__tempInFile}") + "echo \"Processing : ${__tempInFile}\" \n{\n" + customTemplate1 + "\n\n} && ( " + Tracking.trackProcessed("${__tempInFile}") + " ) || ( " + Tracking.trackProcessedFail("${__tempInFile}") + " ) ") + customTemplateEnd + "\n");
        return template;
    }

    public static String BatcherParallel(FileListVariable filesVariable, String customTemplateStart, String customTemplate1, String backgroundCustomTemplate1, String customTemplate2, String backgroundCustomTemplate2, String customTemplateEnd) {
        String inVar1 = "_inputFile1";
        String inVar2 = "_inputFile2";
        String inVar1BaseName = "inputFile1BaseName";
        String inVar2BaseName = "inputFile2BaseName";
        if (customTemplate1 == null || customTemplate1.isEmpty()) {
            customTemplate1 = EMPTY_BLOCK;
        }
        if (customTemplate2 == null || customTemplate2.isEmpty()) {
            customTemplate2 = EMPTY_BLOCK;
        }
        if (backgroundCustomTemplate1 == null || backgroundCustomTemplate1.isEmpty()) {
            backgroundCustomTemplate1 = EMPTY_BLOCK;
        }
        if (backgroundCustomTemplate2 == null || backgroundCustomTemplate2.isEmpty()) {
            backgroundCustomTemplate2 = EMPTY_BLOCK;
        }
        Object template = Tracking.trackProcessTrack(filesVariable);
        template = (String)template + BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", inVar1 + "=\"" + filesVariable.$("0,$_i") + "\"\n" + inVar2 + "=\"" + filesVariable.$("1,$_i") + "\"\n" + inVar1BaseName + "=" + BashHelper.getBaseName("_inputFile1") + "\n__tempInFile=\"${_inputFile1}\"\n" + customTemplateStart + "\nback_commandID=\"${_i}_${" + Tracking.SCRIPT_ID_VARNAME + "}\"\n" + BashHelper.IF("-n \"${" + inVar2 + "}\"", inVar2BaseName + "=" + BashHelper.getBaseName("_inputFile2") + "\n__tempInFile=\"${__tempInFile} , ${_inputFile2}\"\n" + customTemplate2 + "\n" + BashHelper.command_background_withTrack("${__tempInFile}", backgroundCustomTemplate2, "back_commandID"), customTemplate1 + "\n" + BashHelper.command_background_withTrack("${__tempInFile}", backgroundCustomTemplate1, "back_commandID")));
        template = (String)template + "wait \n";
        template = (String)template + BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", inVar1 + "=\"" + filesVariable.$("0,$_i") + "\"\n" + inVar2 + "=\"" + filesVariable.$("1,$_i") + "\"\n" + inVar1BaseName + "=" + BashHelper.getBaseName("_inputFile1") + "\n__tempInFile=\"${_inputFile1}\"\n" + customTemplateStart + "\n" + BashHelper.IF("-n \"${" + inVar2 + "}\"", inVar2BaseName + "=" + BashHelper.getBaseName("_inputFile2") + "\n__tempInFile=\"${__tempInFile} , ${_inputFile2}\"\n" + customTemplate2, customTemplate1) + customTemplateEnd + "\n");
        return template;
    }

    public static String BatcherParallelSingleton(FilesVariable filesVariable, String customTemplateStart, String customTemplateCommand, String customProcessStr) {
        String inVar = "_inputFile";
        String inVarBaseName = "inputFileBaseName";
        Object template = Tracking.trackProcessTrack(filesVariable);
        template = (String)template + BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", inVar + "=\"" + filesVariable.$("$_i") + "\"\n" + inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\nback_commandID=\"${_i}_${inputFileBaseName}_${" + Tracking.SCRIPT_ID_VARNAME + "}\"\n" + customTemplateStart + "\n" + BashHelper.command_background_withTrack("${_inputFile}", customTemplateCommand, "back_commandID", customProcessStr));
        template = (String)template + "wait \n";
        return template;
    }

    public static String BatcherParallelSingleton(FilesVariable filesVariable, String customTemplateStart, String customTemplateCommand) {
        return BashHelper.BatcherParallelSingleton(filesVariable, customTemplateStart, customTemplateCommand, null);
    }

    public static String BatcherParallelSingleton(FileListVariable filesVariable, String customTemplateStart, String backgroundCustomTemplate1, String backgroundCustomTemplate2) {
        String inVar1 = "_inputFile1";
        String inVar2 = "_inputFile2";
        String inVar1BaseName = "inputFile1BaseName";
        String inVar2BaseName = "inputFile2BaseName";
        if (backgroundCustomTemplate1 == null || backgroundCustomTemplate1.isEmpty()) {
            backgroundCustomTemplate1 = EMPTY_BLOCK;
        }
        if (backgroundCustomTemplate2 == null || backgroundCustomTemplate2.isEmpty()) {
            backgroundCustomTemplate2 = EMPTY_BLOCK;
        }
        Object template = Tracking.trackProcessTrack(filesVariable);
        template = (String)template + BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", inVar1 + "=\"" + filesVariable.$("0,$_i") + "\"\n" + inVar2 + "=\"" + filesVariable.$("1,$_i") + "\"\n" + inVar1BaseName + "=" + BashHelper.getBaseName("_inputFile1") + "\n__tempInFile=\"${_inputFile1}\"\n" + customTemplateStart + "\nback_commandID=\"${_i}_${" + Tracking.SCRIPT_ID_VARNAME + "}\"\n" + BashHelper.IF("-n \"${" + inVar2 + "}\"", inVar2BaseName + "=" + BashHelper.getBaseName("_inputFile2") + "\n__tempInFile=\"${__tempInFile} , ${_inputFile2}\"\n" + BashHelper.command_background_withTrack("${__tempInFile}", backgroundCustomTemplate2, "back_commandID"), BashHelper.command_background_withTrack("${__tempInFile}", backgroundCustomTemplate1, "back_commandID")));
        template = (String)template + "wait \n";
        return template;
    }

    public static String Batcher(FileListVariable filesVariable, String customTemplate) {
        String inVar = "_inputFile";
        String inVarBaseName = "inputFileBaseName";
        Object template = Tracking.trackProcessTrack(filesVariable);
        template = (String)template + BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", inVar + "=\"" + filesVariable.$("0,$_i") + "\"\n_p=\"0\"\n" + inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\n" + Tracking.trackProcessing("${_inputFile}") + "echo \"Processing : ${_inputFile}\" \n{\n" + customTemplate + "\n} && ( " + Tracking.trackProcessed("${_inputFile}") + " ) || ( " + Tracking.trackProcessedFail("${_inputFile}") + " ) \necho \"--------------------------------------------------\" \n" + BashHelper.IF("-n \"" + filesVariable.$("1,$_i") + "\"", inVar + "=\"" + filesVariable.$("1,$_i") + "\"\n_p=\"1\"\n" + inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\n" + Tracking.trackProcessing("${_inputFile}") + "echo \"Processing : ${_inputFile}\" \n{\n" + customTemplate + "\n} && ( " + Tracking.trackProcessed("${_inputFile}") + " ) || ( " + Tracking.trackProcessedFail("${_inputFile}") + " ) \necho \"--------------------------------------------------\" \n"));
        return template;
    }

    public static String Batcher_noLog(FileListVariable filesVariable, String customTemplate, boolean silent) {
        String inVar = "_inputFile";
        String inVarBaseName = "inputFileBaseName";
        String echoMsg = "echo \"Processing : ${_inputFile}\" \n";
        if (silent) {
            echoMsg = "";
        }
        String template = BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", inVar + "=\"" + filesVariable.$("0,$_i") + "\"\n_p=\"0\"\n" + inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\n" + echoMsg + customTemplate + BashHelper.IF("-n \"" + filesVariable.$("1,$_i") + "\"", inVar + "=\"" + filesVariable.$("1,$_i") + "\"\n_p=\"1\"\n" + inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\n" + echoMsg + customTemplate));
        return template;
    }

    public static String BatcherParallel(FileListVariable filesVariable, String customTemplate) {
        String inVarBaseName = "inputFileBaseName";
        Object template = Tracking.trackProcessTrack(filesVariable);
        template = (String)template + BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", "_inputFile=\"" + filesVariable.$("0,$_i") + "\"\n" + inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\nback_commandID=\"${_i}_0_${" + Tracking.SCRIPT_ID_VARNAME + "}\"\n" + BashHelper.command_background_withTrack("${_inputFile}", "_p=\"0\"\necho \"Processing : ${_inputFile}\" \n" + customTemplate, "back_commandID") + BashHelper.IF("-n \"" + filesVariable.$("1,$_i") + "\"", "_inputFile=\"" + filesVariable.$("1,$_i") + "\"\n" + inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\nback_commandID=\"${_i}_1_${" + Tracking.SCRIPT_ID_VARNAME + "}\"\n" + BashHelper.command_background_withTrack("${_inputFile}", "_p=\"1\"\necho \"Processing : ${_inputFile}\" \n" + customTemplate, "back_commandID")));
        template = (String)template + "wait \n";
        return template;
    }

    public static String Batcher_noLog(FileListVariable filesVariable, String customTemplateStart, String customTemplate1, String customTemplate2, String customTemplateEnd, boolean silent) {
        String inVar1 = "_inputFile1";
        String inVar2 = "_inputFile2";
        String inVar1BaseName = "inputFile1BaseName";
        String inVar2BaseName = "inputFile2BaseName";
        Object processingMsg = "Working With ";
        processingMsg = "echo \"" + (String)processingMsg + " : ${__tempInFile}\" \n";
        if (silent) {
            processingMsg = "";
        }
        if (customTemplate2 == null || customTemplate2.isEmpty()) {
            customTemplate2 = EMPTY_BLOCK;
        }
        if (customTemplate1 == null || customTemplate1.isEmpty()) {
            customTemplate1 = EMPTY_BLOCK;
        }
        String template = BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", inVar1 + "=\"" + filesVariable.$("0,$_i") + "\"\n" + inVar2 + "=\"" + filesVariable.$("1,$_i") + "\"\n" + inVar1BaseName + "=" + BashHelper.getBaseName("_inputFile1") + "\n__tempInFile=\"${_inputFile1}\"\n" + customTemplateStart + "\n" + BashHelper.IF("-n \"${" + inVar2 + "}\"", inVar2BaseName + "=" + BashHelper.getBaseName("_inputFile2") + "\n__tempInFile=\"${__tempInFile} , ${_inputFile2}\"\n" + (String)processingMsg + customTemplate2, (String)processingMsg + customTemplate1) + customTemplateEnd + "\n");
        return template;
    }

    public static String Batcher_noLog(FileListVariable filesVariable, String customTemplateStart, String customTemplate1, String customTemplate2, String customTemplateEnd) {
        return BashHelper.Batcher_noLog(filesVariable, customTemplateStart, customTemplate1, customTemplate2, customTemplateEnd, false);
    }

    public static String Batcher_noLog(FileListVariable filesVariable, String customTemplateStart, String customTemplate, String customTemplateEnd) {
        return BashHelper.Batcher_noLog(filesVariable, customTemplateStart, customTemplate, customTemplateEnd, false);
    }

    public static String Batcher_noLog(FileListVariable filesVariable, String customTemplateStart, String customTemplate, String customTemplateEnd, boolean silent) {
        String inVarBaseName = "inputFileBaseName";
        Object processingMsg = "Working With ";
        processingMsg = "echo \"" + (String)processingMsg + " : ${_inputFile}\" \n";
        if (silent) {
            processingMsg = "";
        }
        String template = BashHelper.forIndex("_i", filesVariable.getCountAsBashVarName(), "_i++", "_inputFile=\"" + filesVariable.$("0,$_i") + "\"\n" + inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\n_p=\"0\"\n" + (String)processingMsg + customTemplateStart + "\n" + customTemplate + "\n_inputFile=\"" + filesVariable.$("1,$_i") + "\"\n" + BashHelper.IF("-n \"${_inputFile}\"", inVarBaseName + "=" + BashHelper.getBaseName("_inputFile") + "\n_p=\"1\"\n" + (String)processingMsg + customTemplate + "\n") + customTemplateEnd + "\n");
        return template;
    }

    public static String command_withTrack(String filesToTrack, String commandToTrack) {
        String cmd = Tracking.trackProcessing(filesToTrack) + " \n";
        cmd = cmd + "{\n" + BashHelper.addIndenet(BashHelper.injectTraping(commandToTrack)) + " \n} && ( " + Tracking.trackProcessed(filesToTrack) + ") || ( " + Tracking.trackProcessedFail(filesToTrack) + ") \n ";
        return cmd;
    }

    public static String command_background_withTrack(String filesToTrack, String commandToTrack, String commandId) {
        return BashHelper.command_background_withTrack(filesToTrack, commandToTrack, commandId, null);
    }

    public static String command_background_withTrack(String filesToTrack, String commandToTrack, String commandId, String customProcessMsg) {
        String tmpFolder = "$HOME/.gpro/tmp/";
        String tmpLog = tmpFolder + "log_${" + commandId + "}";
        String cmd = "{ # Background Process\n s_wait_p ${" + semaphoreVar + "} \n {\n" + BashHelper.addIndenet(BashHelper.command_withTrack(filesToTrack, commandToTrack, customProcessMsg)) + " } &> " + tmpLog + " \n" + BashHelper.addIndenet(BashHelper.mutex("cat " + tmpLog + " && rm " + tmpLog + " ", SCREEN_LOG_LOCK_HANDLER, SCREEN_LOG_LOCK_HANDLER)) + " s_signal_v ${" + semaphoreVar + "} \n} & \n";
        return cmd;
    }

    public static String command_withTrack(String filesToTrack, String commandToTrack, String subProg) {
        String startProcessing = Tracking.trackProcessing(filesToTrack, subProg);
        if (subProg == null || subProg.isEmpty()) {
            startProcessing = Tracking.trackProcessing(filesToTrack);
        }
        String cmd = startProcessing + " \n";
        cmd = cmd + "{\n" + BashHelper.addIndenet(BashHelper.injectTraping(commandToTrack)) + " \n} && ( " + Tracking.trackProcessed(filesToTrack) + ") || ( " + Tracking.trackProcessedFail(filesToTrack) + ") \n ";
        return cmd;
    }

    public static String injectTraping(String cmlines) {
        return BashHelper.injectTraping(cmlines, null);
    }

    public static String injectTraping(String cmlines, String indent) {
        if (indent == null) {
            indent = "";
        }
        String final_script = indent + BashHelper.st("trap process_command DEBUG");
        if (cmlines.equals(EMPTY_BLOCK)) {
            return EMPTY_BLOCK;
        }
        String[] stringArray = cmlines.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.strip().toLowerCase().startsWith("if") || line.strip().toLowerCase().startsWith("then") || line.strip().toLowerCase().startsWith("flock") || line.strip().toLowerCase().startsWith("eval") || line.strip().toLowerCase().startsWith("printf") || line.strip().toLowerCase().startsWith("echo") || line.strip().toLowerCase().startsWith("#") || line.strip().toLowerCase().equals("fi") || line.strip().equals("")) {
                final_script = final_script + indent + BashHelper.st(line);
            } else {
                final_script = final_script + indent + BashHelper.st(line);
                final_script = final_script + indent + BashHelper.st("track");
            }
            ++n2;
        }
        final_script = final_script + indent + BashHelper.st("code=$?");
        final_script = final_script + indent + BashHelper.st("trap - DEBUG");
        final_script = final_script + indent + BashHelper.st("Return $code");
        return final_script;
    }

    public static String injectTraping(String cmlines, String indent, String sharedStatusVar) {
        if (indent == null) {
            indent = "";
        }
        String final_script = indent + BashHelper.st("trap process_command DEBUG");
        if (cmlines.equals(EMPTY_BLOCK)) {
            return EMPTY_BLOCK;
        }
        String[] stringArray = cmlines.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.strip().toLowerCase().startsWith("if") || line.strip().toLowerCase().startsWith("then") || line.strip().toLowerCase().startsWith("flock") || line.strip().toLowerCase().startsWith("eval") || line.strip().toLowerCase().startsWith("printf") || line.strip().toLowerCase().startsWith("echo") || line.strip().toLowerCase().startsWith("#") || line.strip().toLowerCase().equals("fi") || line.strip().equals("")) {
                final_script = final_script + indent + BashHelper.st(line);
            } else {
                final_script = final_script + indent + BashHelper.st(line);
                final_script = final_script + indent + BashHelper.st("track");
            }
            ++n2;
        }
        final_script = final_script + indent + BashHelper.st("code=$?");
        final_script = final_script + indent + BashHelper.st("trap - DEBUG");
        final_script = sharedStatusVar != null ? final_script + indent + BashHelper.st("Return $code " + sharedStatusVar) : final_script + indent + BashHelper.st("Return $code");
        return final_script;
    }

    public static String mutex(String exculsiveBlock, String fileHandlerNum, String fileHandlerName) {
        return "\n\n#==================MUTEX BLOCK================\neval \"exec ${" + fileHandlerNum + "}>${" + fileHandlerName + "}\"\nflock -e ${" + fileHandlerNum + "}\n\n" + BashHelper.addIndenet(exculsiveBlock) + "\nflock -u ${" + fileHandlerNum + "}\n#---------------------------------------------\n";
    }

    static String addIndenet(String block) {
        String[] blockLines;
        StringBuilder mBlock = new StringBuilder();
        String[] stringArray = blockLines = block.split("\n");
        int n = blockLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            mBlock.append("\t" + line + "\n");
            ++n2;
        }
        return mBlock.toString();
    }

    public static String block(String blockLines) {
        return "{ \n " + blockLines + " \n} ";
    }

    public static String echo(String msg) {
        return "echo \"" + msg + "\"\n";
    }

    public static String assign(JobVariable variable, String value) {
        return variable.getBashVarName() + "=\"" + value + "\"";
    }

    public static String assign(String varName, JobVariable variable) {
        return varName + "=\"" + variable.$() + "\"";
    }

    public static String assign(JobVariable variable, String index, String value) {
        return variable.getBashVarName(index) + "=\"" + value + "\"";
    }

    public static String assign(String varName, String value) {
        return varName + "=\"" + value + "\"";
    }

    public static String assign(String varName, String value, boolean noQuates) {
        if (!noQuates) {
            return BashHelper.assign(varName, value);
        }
        return varName + "=" + value;
    }

    public static String assign(JobVariable variable, JobVariable variable2) {
        return variable.getBashVarName() + "=\"" + variable2.$() + "\"";
    }

    public static String strAppend(String lsVar, String str) {
        return BashHelper.assign(lsVar, BashHelper.$(lsVar) + str);
    }

    public static String $(String lsVar) {
        return "${" + lsVar + "}";
    }

    public static String arrayAdd(JobVariable variable, String value) {
        return variable.getBashVarName() + "+=(\"" + value + "\")";
    }

    public static String arrayAdd(String variableName, String value) {
        return variableName + "+=(\"" + value + "\")";
    }

    public static String st(String statment) {
        return statment + "\n";
    }

    public static String qt(String str) {
        return "\"" + str + "\"";
    }

    public static String hlpArrAppend(JobVariable filesVar) {
        return "$(hlp_arrAppend " + filesVar.getBashVarName("@") + ")";
    }

    public static String hlpArrAppend(JobVariable filesVar, String sep) {
        if (sep == null) {
            sep = "";
        }
        return "$(hlp_arrAppend " + filesVar.getBashVarName("@") + " \"" + sep + "\")";
    }

    public static String hlpCmdSwitchAppend(JobVariable filesVar, String cmdSwitch, String sep) {
        return "$(hlp_arrCmdAppend " + filesVar.getBashVarName("@") + " " + cmdSwitch + " " + BashHelper.bashDoubelQuate(sep) + " )";
    }

    public static String hlpCmdSwitchAppend(JobVariable filesVar, String cmdSwitch, String sep, String quate) {
        return "$(hlp_arrCmdAppend " + filesVar.getBashVarName("@") + " " + cmdSwitch + " " + BashHelper.bashDoubelQuate(sep) + " " + BashHelper.bashDoubelQuate(BashHelper.bashCharEscape(quate)) + " )";
    }

    public static String bashCharEscape(String inStr) {
        String escapedStr = inStr.replace("\"", "\\\"");
        return escapedStr;
    }

    public static String bashDoubelQuate(String inStr) {
        return "\"" + inStr + "\"";
    }

    public static class Path {
        public static String path(String p1, String p2) {
            return p1 + "/" + p2;
        }
    }
}

