/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.configuration;

import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.ValidationResult;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.manager.WorkflowCatalog;
import com.biotechvana.workflow.template.WorkflowTemplate;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;

public class SimpleWorkflowConfiguration
implements IPipelineConfiguration {
    protected transient IWorkflowManager workflowManager;
    protected transient Workflow pipeline;
    protected transient WorkflowTemplate templateWorkflow;
    private transient WorkflowStartupJob startupJob;
    private String projectName = "";
    private String projectFolder = "/Projects";
    String workflowTemplateId = "";
    String workflowID = "";
    String workflowDesc = "";
    protected Properties variables = new Properties();

    public SimpleWorkflowConfiguration(IWorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    public String saveFileToDisc(String filePath) {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
        filePath = (String)filePath + "/" + this.projectName + ".config";
        try {
            BufferedWriter br = new BufferedWriter(new FileWriter((String)filePath));
            br.write(gson.toJson((Object)this));
            br.close();
            return filePath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectName = projectName;
        System.out.println(projectName);
        if (this.pipeline != null) {
            this.pipeline.setWorkflowName(projectName);
            WorkflowCatalog.fixGeneratedID(this.pipeline);
            System.out.println("getWorkflowName " + this.pipeline.getWorkflowName());
            System.out.println("getWorkflowID " + this.pipeline.getWorkflowId());
            System.out.println("getTemplateId : " + this.pipeline.getMetadata().getTemplateId());
            this.workflowID = this.pipeline.getWorkflowId();
        }
    }

    @Override
    public String getPojectName() {
        return this.projectName;
    }

    @Override
    public final void setWorkflowTemplateId(String templateID) {
        Assert.isLegal((templateID != null ? 1 : 0) != 0);
        this.workflowTemplateId = templateID;
        this.templateWorkflow = this.workflowManager.getWorkflowCatalog().getTemplateByID(templateID);
        this.workflowDesc = this.templateWorkflow.getMetadata().getName() + " - " + this.templateWorkflow.getMetadata().getDesc();
        this.setProjectName(this.templateWorkflow.getDefaultWorkflowName());
        this.pipeline = this.workflowManager.getWorkflowCatalog().createPiplineFromTemplate(this.workflowTemplateId, this.getPojectName());
        this.startupJob = this.pipeline.getStartupJob();
        this.workflowID = this.pipeline.getWorkflowId();
        this.onSettingWorkflow();
    }

    protected void onSettingWorkflow() {
    }

    @Override
    public IValidationResult feedWorkflow() {
        if (this.pipeline == null) {
            return null;
        }
        this.projectName = this.pipeline.getStartupJob().getValue("PROJECT_NAME");
        this.pipeline.setWorkflowName(this.projectName);
        String pipelineOutputFolder = this.pipeline.getStartupJob().getValue("INPUT_OUTPUT_FOLDER");
        if (pipelineOutputFolder.isEmpty()) {
            String defaultJobFolder = "/Projects";
            this.projectFolder = !this.workflowManager.getUserManager().getIsChRooted() ? this.workflowManager.getUserManager().getHostPathManager().getUserHomePath() + defaultJobFolder : defaultJobFolder;
            this.pipeline.getStartupJob().getVariable("INPUT_OUTPUT_FOLDER").setValue(this.projectFolder);
        } else {
            this.projectFolder = pipelineOutputFolder;
        }
        return ValidationResult.Valid_RESULT;
    }

    @Override
    public IValidationResult validate() {
        String errMsg = "";
        if (this.pipeline == null) {
            errMsg = "No Pipeline selected";
        } else if (!this.pipeline.isValid()) {
            errMsg = this.pipeline.getFirstErrorMsg();
        }
        errMsg = "";
        if (!errMsg.isEmpty()) {
            new ValidationResult(4, -1, errMsg);
        }
        return ValidationResult.Valid_RESULT;
    }

    @Override
    public String getWorkflowDesc() {
        if (this.templateWorkflow != null) {
            return this.templateWorkflow.getMetadata().getName() + " - " + this.templateWorkflow.getMetadata().getDesc();
        }
        return "No Pipeline Selected";
    }

    @Override
    public String getWorkflowTemplateId() {
        return this.workflowTemplateId;
    }

    @Override
    public Workflow getWorkflow() {
        return this.pipeline;
    }

    @Override
    public String getPipelineId() {
        return this.workflowID;
    }

    @Override
    public void setPipeline(Workflow pipeline) {
        this.pipeline = pipeline;
        this.workflowTemplateId = pipeline.getMetadata().getTemplateId();
        this.templateWorkflow = this.workflowManager.getWorkflowCatalog().getTemplateByID(this.workflowTemplateId);
        this.projectName = pipeline.getStartupJob().getValue("PROJECT_NAME");
    }

    @Override
    public String getProjectFolder() {
        return this.projectFolder;
    }

    @Override
    public void addVariable(String key, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (key == null || key.isEmpty()) {
            return;
        }
        this.variables.put(key, value);
    }

    @Override
    public String getVariable(String key) {
        return this.variables.getProperty(key);
    }

    @Override
    public void setWorkflowManager(IWorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }
}

