/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow;

import com.biotechvana.pipelinestools.utils.PipelineExecutor;
import com.biotechvana.pipelinestools.utils.PipelineUtils;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.Constants;
import com.biotechvana.utils.PreferenceManager;
import com.biotechvana.workflow.ITask;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.WorkflowMetadata;
import com.biotechvana.workflow.WorkflowObservable;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.manager.IWorkflowManager;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;

public class Workflow
extends WorkflowObservable
implements ITask {
    private WorkflowMetadata metadata = new WorkflowMetadata("");
    WorkflowStartupJob startjob;
    ArrayList<WorkflowJob> jobs = new ArrayList();
    HashMap<String, Integer> jobsIds = new HashMap();
    int nJobsWithFolder = 0;
    HashMap<String, String> jobsToJobsMapping;
    String firstErrorMsg;

    @Deprecated
    public Workflow createClone() {
        return null;
    }

    public String getWorkflowId() {
        String ID = "0";
        if (this.metadata != null) {
            ID = this.metadata.getPipelineID();
        }
        return ID;
    }

    public void setWorkflowId(String id) {
        this.metadata.setPipelineID(id);
    }

    public void setMetadata(WorkflowMetadata metadata) {
        for (Object key : metadata.keySet()) {
            this.metadata.setProperty((String)key, metadata.getProperty((String)key));
        }
    }

    public WorkflowMetadata getMetadata() {
        return this.metadata;
    }

    public Workflow() {
        this.startjob = new WorkflowStartupJob("Workflow_Options", "Workflow Options");
        this.addJob(this.startjob);
    }

    public WorkflowStartupJob getStartupJob() {
        return this.startjob;
    }

    public Workflow(WorkflowStartupJob startjob) {
        this.startjob = startjob;
        this.addJob(startjob);
    }

    public void setWorkflowName(String workflowName) {
        workflowName = workflowName.replace(" ", "_");
        this.startjob.setValue("PROJECT_NAME", workflowName);
    }

    public String getWorkflowName() {
        String name = this.startjob.getValue("PROJECT_NAME");
        return name.replace(" ", "_");
    }

    public void addJob(WorkflowJob workflowJob) {
        int nJobs;
        if (!this.jobs.contains(workflowJob)) {
            this.jobs.add(workflowJob);
            if (workflowJob != this.startjob) {
                if (workflowJob.hasVariable("EMAIL_VAR")) {
                    workflowJob.addVariableMap("EMAIL_VAR", this.startjob.getVariable("EMAIL_VAR"));
                }
                if (workflowJob.hasVariable("INPUT_OUTPUT_FOLDER")) {
                    workflowJob.addVariableMap("INPUT_OUTPUT_FOLDER", this.startjob.getVariable("JOB_OUTPUT_FOLDER"));
                }
                if (workflowJob.hasVariable("USER_MAX_NUM_SPAWN_PROCESSES")) {
                    workflowJob.addVariableMap("USER_MAX_NUM_SPAWN_PROCESSES", this.startjob.getVariable("USER_MAX_NUM_SPAWN_PROCESSES"));
                }
            }
        }
        workflowJob.setWorkflow(this);
        String newJobId = workflowJob.getJobID();
        if (this.jobsIds.containsKey(newJobId)) {
            nJobs = this.jobsIds.get(newJobId);
            workflowJob.setJobId(newJobId + "_" + ++nJobs);
            this.jobsIds.put(newJobId, nJobs);
        } else {
            this.jobsIds.put(newJobId, 0);
        }
        this.metadata.addTag(workflowJob.getJobDescID());
        this.metadata.addTag(workflowJob.getJobTags());
        this.metadata.addChar(workflowJob.getJobChars());
        if (workflowJob != this.startjob && workflowJob.hasVariable("JOB_OUTPUT_FOLDER")) {
            ++this.nJobsWithFolder;
            nJobs = this.nJobsWithFolder;
            Object customName = workflowJob.getJobDescID();
            customName = nJobs <= 9 ? "0" + nJobs + "_" + (String)customName : nJobs + "_" + (String)customName;
            workflowJob.setValue("INPUT_CUSTOM_JOB_NAME", (String)customName);
        }
    }

    @Deprecated
    public void setEmail(String email) {
        this.startjob.setValue("EMAIL_VAR", email);
    }

    public List<WorkflowJob> getAllJobs() {
        return this.jobs;
    }

    @Deprecated
    public void setResultFolder(String resultFolder) {
        this.startjob.setValue("INPUT_OUTPUT_FOLDER", resultFolder);
    }

    @Deprecated
    public boolean RunWorkflow(IWorkflowManager workflowManager) {
        if (!this.isValid()) {
            return false;
        }
        StringBuilder command = new StringBuilder();
        String user = PreferenceManager.getInstance().get("ssh_user", "");
        for (WorkflowJob job : this.jobs) {
            String jobCommand = job.getJobCommand();
            command.append(jobCommand);
            System.out.println(job.getJobDescID());
            System.out.println(jobCommand);
        }
        return PipelineExecutor.runCommandWithHTTP(workflowManager.getUserManager(), command.toString(), "", "", "");
    }

    public String getWorkflowFolder() {
        return this.startjob.getValue("INPUT_OUTPUT_FOLDER");
    }

    public String getWorkflowScriptPath(IWorkflowManager workflowManager) {
        String workflowFolder = this.startjob.getValue("INPUT_OUTPUT_FOLDER");
        String workflowName = this.getWorkflowName();
        String commandFile = PipelineUtils.sanitizeFilePathWithTelda(workflowManager.getUserManager().getHostPathManager().getUserHomePath(), workflowFolder + "/." + workflowName + "_command", workflowManager.getUserManager().getIsChRooted());
        return commandFile;
    }

    public boolean getCommand(IWorkflowManager workflowManager, StringBuilder command) {
        boolean isValidPipeline = true;
        String workflowFolder = this.startjob.getValue("INPUT_OUTPUT_FOLDER");
        String workflowName = this.getWorkflowName();
        workflowFolder.isEmpty();
        String commandFile = PipelineUtils.sanitizeFilePathWithTelda(workflowManager.getUserManager().getHostPathManager().getUserHomePath(), workflowFolder + "/." + workflowName + "_command", workflowManager.getUserManager().getIsChRooted());
        String logFile = PipelineUtils.sanitizeFilePathWithTelda(workflowManager.getUserManager().getHostPathManager().getUserHomePath(), workflowFolder + "/" + workflowName + "_log", workflowManager.getUserManager().getIsChRooted());
        String maxNumOfJobs = PreferenceManager.getInstance().get("MAX_PROCESSES", "");
        String user = PreferenceManager.getInstance().get("ssh_user", "");
        command.append("export USER_HOME=$HOME\n");
        command.append("export PATH=$PATH:" + Constants.PIPELINE_BASE_PATH + ";\n");
        command.append("source helper.v2.sh\n");
        command.append("source trackHelper.v2.sh\n");
        this.startjob.getVariable("JOB_OUTPUT_FOLDER").setRelativeTo(this.startjob.getVariable("INPUT_OUTPUT_FOLDER"));
        String workflowFolderName = this.startjob.getValue("PROJECT_NAME");
        workflowFolderName = workflowFolderName.replace(" ", "_");
        this.startjob.setValue("JOB_OUTPUT_FOLDER", workflowFolderName);
        command.append(this.startjob.getVariable("INPUT_OUTPUT_FOLDER").getBashVarDecleration());
        command.append(this.startjob.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration());
        command.append(this.startjob.getVariable("EMAIL_VAR").getBashVarDecleration());
        command.append("mkdir \"" + this.startjob.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        if (this.startjob.hasVariable("USER_MAX_NUM_SPAWN_PROCESSES")) {
            maxNumOfJobs = this.startjob.getValue("USER_MAX_NUM_SPAWN_PROCESSES");
        }
        command.append(BashHelper.USER_MAX_NUM_PROCESS_VAR + "=\"" + maxNumOfJobs + "\"\n");
        command.append("mkdir \"" + this.startjob.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        command.append("##    submission history and tracking   \n");
        command.append(Tracking.submitEntry(workflowManager.getUserManager(), commandFile, this.startjob.getVariable("INPUT_OUTPUT_FOLDER").$(), "w", workflowName, this.getWorkflowId()));
        command.append(Tracking.trackStart(workflowName));
        command.append("\n{   # Start of main pipeline script \n");
        String jobCommand = this.startjob.getJobCommand();
        if (!this.startjob.isValid()) {
            isValidPipeline = false;
        }
        command.append(jobCommand);
        int nJobs = 1;
        for (WorkflowJob job : this.jobs) {
            if (job == this.startjob) continue;
            command.append("\n");
            command.append("##  ==================================================================== \n");
            command.append("##  ==================================================================== \n");
            command.append("##                         " + job.getFriendlyName() + "\n");
            command.append("##  ==================================================================== \n\n");
            Object outputFolder = job.getJobDescID();
            outputFolder = nJobs <= 9 ? "0" + nJobs + "_" + (String)outputFolder : nJobs + "_" + (String)outputFolder;
            if (job.hasVariable("JOB_OUTPUT_FOLDER")) {
                job.setValue("JOB_OUTPUT_FOLDER", (String)outputFolder);
                ++nJobs;
            }
            command.append("echo \"================================================================\"\n");
            command.append("echo \"Starting  " + job.getFriendlyName() + "  \"\n");
            jobCommand = job.getJobCommand();
            if (!job.isValid()) {
                isValidPipeline = false;
            }
            if (job.hasVariable("JOB_OUTPUT_FOLDER")) {
                command.append(job.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration() + "\n");
                command.append("mkdir \"" + job.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
            }
            command.append(jobCommand);
            command.append("##  -------------------------------------------------------------------- \n");
            command.append("##                      END " + job.getFriendlyName() + "\n");
            command.append("##  -------------------------------------------------------------------- \n");
            command.append("##  -------------------------------------------------------------------- \n\n\n");
        }
        command.append("} &> " + logFile + "\n");
        String statusVar = "_g_status_fail_";
        String cmdCheck = "\n" + statusVar + "=false\n";
        cmdCheck = cmdCheck + BashHelper.IF("${" + statusVar + "} = true", Tracking.trackLog(Tracking.TrackEventType.Failed, workflowName, "Job Fail .... terminate execution.") + "exit -1", Tracking.trackLog(Tracking.TrackEventType.Ended, workflowName));
        command.append(cmdCheck);
        if (!isValidPipeline) {
            return false;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("/home/ahafez/w_test_command.sh"), "utf-8"));
            writer.write(command.toString());
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            System.out.println(ex.getStackTrace());
        }
        return true;
    }

    @Deprecated
    protected boolean RunPipeline(IWorkflowManager workflowManager) {
        String maxNumOfJobs = PreferenceManager.getInstance().get("MAX_PROCESSES", "");
        boolean isValidPipeline = true;
        String workflowFolder = this.startjob.getValue("INPUT_OUTPUT_FOLDER");
        String workflowName = this.getWorkflowName();
        workflowFolder.isEmpty();
        UserManager.RemotePathManager hostPathManager = workflowManager.getUserManager().getHostPathManager();
        String commandFile = hostPathManager.sanitizeFilePathWithTelda(workflowFolder + "/." + workflowName + "_command");
        String logFile = hostPathManager.sanitizeFilePathWithTelda(workflowFolder + "/" + workflowName + "_log");
        String errorFile = hostPathManager.sanitizeFilePathWithTelda(workflowFolder + "/" + workflowName + "_error");
        StringBuilder command = new StringBuilder();
        String user = PreferenceManager.getInstance().get("ssh_user", "");
        command.append(BashHelper.USER_MAX_NUM_PROCESS_VAR + "=\"" + maxNumOfJobs + "\"\n");
        command.append("export PATH=$PATH:" + Constants.PIPELINE_BASE_PATH + ";\n");
        command.append("source helper.v2.sh\n");
        command.append("source trackHelper.v2.sh\n");
        this.startjob.getVariable("JOB_OUTPUT_FOLDER").setRelativeTo(this.startjob.getVariable("INPUT_OUTPUT_FOLDER"));
        String workflowFolderName = this.startjob.getValue("PROJECT_NAME");
        workflowFolderName = workflowFolderName.replace(" ", "_");
        this.startjob.setValue("JOB_OUTPUT_FOLDER", workflowFolderName);
        command.append(this.startjob.getVariable("INPUT_OUTPUT_FOLDER").getBashVarDecleration());
        command.append(this.startjob.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration());
        command.append(this.startjob.getVariable("EMAIL_VAR").getBashVarDecleration());
        command.append("mkdir \"" + this.startjob.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        command.append("##    submission history and tracking   \n");
        command.append(Tracking.submitEntry(workflowManager.getUserManager(), commandFile, this.startjob.getVariable("INPUT_OUTPUT_FOLDER").$(), "w", workflowName, this.getWorkflowId()));
        command.append(Tracking.trackStart(workflowName));
        command.append("\n{   # Start of main pipeline script \n");
        String jobCommand = this.startjob.getJobCommand();
        if (!this.startjob.isValid()) {
            isValidPipeline = false;
        }
        command.append(jobCommand);
        int nJobs = 1;
        for (WorkflowJob job : this.jobs) {
            if (job == this.startjob) continue;
            command.append("\n");
            command.append("##  ==================================================================== \n");
            command.append("##  ==================================================================== \n");
            command.append("##                         " + job.getFriendlyName() + "\n");
            command.append("##  ==================================================================== \n\n");
            Object outputFolder = job.getJobDescID();
            outputFolder = nJobs <= 9 ? "0" + nJobs + "_" + (String)outputFolder : nJobs + "_" + (String)outputFolder;
            if (job.hasVariable("JOB_OUTPUT_FOLDER")) {
                job.setValue("JOB_OUTPUT_FOLDER", (String)outputFolder);
                ++nJobs;
            }
            command.append("echo \"================================================================\"\n");
            command.append("echo \"Starting  " + job.getFriendlyName() + "  \"\n");
            jobCommand = job.getJobCommand();
            if (!job.isValid()) {
                isValidPipeline = false;
            }
            if (job.hasVariable("JOB_OUTPUT_FOLDER")) {
                command.append(job.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration() + "\n");
                command.append("mkdir \"" + job.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
            }
            command.append(jobCommand);
            command.append("##  -------------------------------------------------------------------- \n");
            command.append("##                      END " + job.getFriendlyName() + "\n");
            command.append("##  -------------------------------------------------------------------- \n");
            command.append("##  -------------------------------------------------------------------- \n\n\n");
        }
        command.append("} &> " + logFile + "\n");
        String statusVar = "_g_status_fail_";
        String cmdCheck = "\n" + statusVar + "=false\n";
        cmdCheck = cmdCheck + BashHelper.IF("${" + statusVar + "} = true", Tracking.trackLog(Tracking.TrackEventType.Failed, workflowName, "Job Fail .... terminate execution.") + "exit -1", Tracking.trackLog(Tracking.TrackEventType.Ended, workflowName));
        command.append(cmdCheck);
        if (!isValidPipeline) {
            return false;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("/home/ahafez/pipeline_command.sh"), "utf-8"));
            writer.write(command.toString());
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            System.out.println(ex.getStackTrace());
        }
        return PipelineExecutor.runCommandWithHTTP(workflowManager.getUserManager(), command.toString(), "", "", commandFile);
    }

    public boolean removeJob(WorkflowJob workflowJob) {
        boolean retValue = this.jobs.remove(workflowJob);
        workflowJob.unLink(this);
        WorkflowJob[] preJobs = workflowJob.getPreJobs();
        WorkflowJob[] postJobs = workflowJob.getPostJobs();
        WorkflowJob[] workflowJobArray = preJobs;
        int n = preJobs.length;
        int n2 = 0;
        while (n2 < n) {
            WorkflowJob preJob = workflowJobArray[n2];
            workflowJob.removeMappingTo(preJob);
            ++n2;
        }
        workflowJobArray = postJobs;
        n = postJobs.length;
        n2 = 0;
        while (n2 < n) {
            WorkflowJob postJob = workflowJobArray[n2];
            postJob.removeMappingTo(workflowJob);
            ++n2;
        }
        this.notifyStructurechanged();
        return retValue;
    }

    public void addJob(WorkflowJob workflowJob, int index) {
        if (!this.jobs.contains(workflowJob)) {
            this.jobs.add(index + 1, workflowJob);
            if (workflowJob.hasVariable("EMAIL_VAR")) {
                workflowJob.addVariableMap("EMAIL_VAR", this.startjob.getVariable("EMAIL_VAR"));
            }
            if (workflowJob.hasVariable("INPUT_OUTPUT_FOLDER")) {
                workflowJob.addVariableMap("INPUT_OUTPUT_FOLDER", this.startjob.getVariable("INPUT_OUTPUT_FOLDER"));
            }
        }
        this.notifyStructurechanged();
    }

    public void removeMapping(String outVar, String inVar) throws IllegalArgumentException, NoSuchElementException {
        String[] outVars = outVar.split(":");
        String[] inVars = inVar.split(":");
        if (outVars.length != 2) {
            throw new IllegalArgumentException("Output Variable is not Valid, must be in the format jobName:varName");
        }
        if (inVars.length != 2) {
            throw new IllegalArgumentException("input Variable is not Valid, must be in the format jobName:varName");
        }
        WorkflowJob outputtingJob = this.getJobById(outVars[0]);
        if (outputtingJob == null) {
            throw new NoSuchElementException("Output Job specified does not exist in the current workflow");
        }
        WorkflowJob inputJob = this.getJobById(inVars[0]);
        if (inputJob == null) {
            throw new NoSuchElementException("Input Job specified does not exist in the current workflow");
        }
        inputJob.removeVariableMap(inVars[1]);
    }

    public void addMapping(String outVar, String inVar) throws IllegalArgumentException, NoSuchElementException {
        String[] outVars = outVar.split(":");
        String[] inVars = inVar.split(":");
        if (outVars.length != 2) {
            throw new IllegalArgumentException("Output Variable is not Valid, must be in the format jobName:varName");
        }
        if (inVars.length != 2) {
            throw new IllegalArgumentException("Input Variable is not Valid, must be in the format jobName:varName");
        }
        this.addMapping(outVars[0], outVars[1], inVars[0], inVars[1]);
    }

    public void addMappingFullName(String outVar, String inVar) throws IllegalArgumentException, NoSuchElementException {
        String[] outVars = outVar.split("\\.");
        String[] inVars = inVar.split("\\.");
        if (outVars.length != 3) {
            throw new IllegalArgumentException("Output Variable is not Valid, must be in the format workflowName.jobName.varName");
        }
        if (inVars.length != 3) {
            throw new IllegalArgumentException("Input Variable is not Valid, must be in the format workflowName.jobName.varName");
        }
        this.addMapping(outVars[1], outVars[2], inVars[1], inVars[2]);
    }

    public WorkflowJob getJobById(String jobId) {
        for (WorkflowJob job : this.jobs) {
            if (!job.getJobID().equals(jobId)) continue;
            return job;
        }
        return null;
    }

    public WorkflowJob getJobByType(String descId) {
        for (WorkflowJob job : this.jobs) {
            if (!job.getJobDescID().equals(descId)) continue;
            return job;
        }
        return null;
    }

    public void addMapping(String outJobID, String outVar, String inJobID, String inVar) throws NoSuchElementException {
        WorkflowJob outputtingJob = this.getJobById(outJobID);
        if (outputtingJob == null) {
            throw new NoSuchElementException("Output Job specified does not exist in the current workflow : " + outJobID);
        }
        WorkflowJob inputJob = this.getJobById(inJobID);
        if (inputJob == null) {
            throw new NoSuchElementException("Input Job specified does not exist in the current workflow : " + inJobID);
        }
        inputJob.addVariableMap(inVar, outputtingJob.getVariable(outVar));
        this.notifyStructurechanged();
    }

    public void addMapping(WorkflowJob outputtingJob, String outVar, WorkflowJob inputJob, String inVar) throws NoSuchElementException {
        if (outputtingJob == null) {
            throw new NoSuchElementException("Output Job specified does not exist in the current workflow");
        }
        if (inputJob == null) {
            throw new NoSuchElementException("Input Job specified does not exist in the current workflow");
        }
        if (!outputtingJob.hasVariable(outVar)) {
            throw new NoSuchElementException("Output Job " + outputtingJob.getJobID() + ":" + outputtingJob.getFriendlyName() + " does not have variable with key:" + outVar);
        }
        inputJob.addVariableMap(inVar, outputtingJob.getVariable(outVar));
        this.notifyStructurechanged();
    }

    public boolean isValid() {
        this.firstErrorMsg = null;
        boolean valid = true;
        for (WorkflowJob job : this.jobs) {
            if (job.isValid()) continue;
            System.out.println(job.jobName + "  is not valid");
            valid = false;
            if (this.firstErrorMsg != null) continue;
            this.firstErrorMsg = job.getFriendlyName() + ":" + job.getFirstErrorMsg();
        }
        return valid;
    }

    public String getFirstErrorMsg() {
        return this.firstErrorMsg;
    }

    public ArrayList<String> getAllErrorMsgs() {
        ArrayList<String> all = new ArrayList<String>();
        for (WorkflowJob job : this.jobs) {
            all.add(job.getJobID());
            all.addAll(job.getAllErrorMsgs());
        }
        return all;
    }

    public WorkflowJob getLastJob() {
        if (this.jobs.isEmpty()) {
            return null;
        }
        return this.jobs.get(this.jobs.size() - 1);
    }

    public void rePosistionAfter(WorkflowJob nextJob, WorkflowJob afterJob) {
        int indexOfNextJob = this.jobs.indexOf(nextJob);
        int indexOfafterJob = this.jobs.indexOf(afterJob);
        this.jobs.remove(indexOfNextJob);
        this.jobs.add(indexOfafterJob + 1, nextJob);
    }

    public String getFullKey() {
        return this.getWorkflowName();
    }
}

