/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow;

import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.JobVariable;

public class VariablesRule {
    private JobVariable conVariable;
    private JobVariable actionVar;
    private Condition con;
    private Action action;
    private String conValue;
    private String actionValue;

    public VariablesRule(JobVariable v1, JobVariable v2, Condition condition, Action action) {
        this.con = condition;
        this.action = action;
        this.conVariable = v1;
        this.actionVar = v2;
        v1.addRule(this);
        v2.addAction(this);
        v1.enforceRules();
    }

    public VariablesRule(JobVariable v1, JobVariable v2, Condition condition, Action action, boolean reverseRule) {
        this(v1, v2, condition, action);
        this.addReverseRule();
        v1.enforceRules();
    }

    public VariablesRule(JobVariable v1, JobVariable v2, Condition condition, Action action, String conValue, String actionValue) {
        this(v1, v2, condition, action);
        this.actionValue = actionValue;
        this.conValue = conValue;
        v1.enforceRules();
    }

    public VariablesRule(JobVariable v1, JobVariable v2, Condition condition, Action action, String conValue, String actionValue, boolean reverseRule) {
        this(v1, v2, condition, action, conValue, actionValue);
        this.addReverseRule();
        v1.enforceRules();
    }

    public VariablesRule(JobVariable v1, JobVariable v2, Condition condition, Action action, String conValue) {
        this(v1, v2, condition, action);
        this.conValue = conValue;
        v1.enforceRules();
    }

    public VariablesRule(JobVariable v1, JobVariable v2, Condition condition, Action action, String conValue, boolean reverseRule) {
        this(v1, v2, condition, action, conValue);
        this.addReverseRule();
        v1.enforceRules();
    }

    private void addReverseRule() {
        Action newAction = Action.SetValueTo;
        Condition newCondition = Condition.EqualTo;
        String newActionValue = this.actionValue;
        String newConValue = this.conValue;
        if (this.con == Condition.EqualTo) {
            newCondition = Condition.NotEqualTo;
        }
        if (this.con == Condition.NotEqualTo) {
            newCondition = Condition.EqualTo;
        }
        if (this.con == Condition.Contain) {
            newCondition = Condition.NotContain;
        }
        if (this.con == Condition.NotContain) {
            newCondition = Condition.Contain;
        }
        if (this.con == Condition.True) {
            newCondition = Condition.False;
        }
        if (this.con == Condition.False) {
            newCondition = Condition.True;
        }
        if (this.action == Action.Enable) {
            newAction = Action.Disable;
        }
        if (this.action == Action.Disable) {
            newAction = Action.Enable;
        }
        if (this.action == Action.ChangeTitle) {
            newAction = Action.ChangeTitle;
            newActionValue = this.actionVar.getDescFriendlyName();
        }
        if (this.action == Action.SetToNotRequired) {
            newAction = Action.SetToRequired;
        }
        if (this.action == Action.SetToRequired) {
            newAction = Action.SetToNotRequired;
        }
        if (newAction == Action.SetValueTo) {
            newAction = Action.Reset;
        }
        if (newAction == Action.Reset) {
            newAction = Action.Reset;
        }
        if (newAction == Action.SetValueTo) {
            return;
        }
        VariablesRule newRule = new VariablesRule(this.conVariable, this.actionVar, newCondition, newAction);
        newRule.setActionValue(newActionValue);
        newRule.setConValue(newConValue);
    }

    public void setConValue(String conValue) {
        this.conValue = conValue;
    }

    public void setActionValue(String actionValue) {
        this.actionValue = actionValue;
    }

    public JobVariable getCondtionVariable() {
        return this.conVariable;
    }

    public JobVariable getActionVariable() {
        return this.actionVar;
    }

    public Condition getCondition() {
        return this.con;
    }

    public Action getAction() {
        return this.action;
    }

    public String getActionValue() {
        return this.actionValue;
    }

    public String getConditionValue() {
        return this.conValue;
    }

    public boolean applyRule(JobVariable conVariable, JobVariable actionVar) {
        boolean isConTrue = this.isTrue(conVariable);
        if (isConTrue) {
            if (this.action == Action.Enable) {
                actionVar.setEnable(isConTrue);
                actionVar.reset();
                return true;
            }
            if (this.action == Action.Disable) {
                actionVar.setEnable(!isConTrue);
                actionVar.reset();
                return true;
            }
            if (this.action == Action.SetToRequired) {
                actionVar.setRequired(true);
                return true;
            }
            if (this.action == Action.SetToNotRequired) {
                actionVar.setRequired(false);
                return true;
            }
            if (this.action == Action.SetValueTo) {
                actionVar.setValue(this.actionValue);
                return true;
            }
            if (this.action == Action.Reset) {
                actionVar.setDefualt();
                return true;
            }
            if (this.action == Action.ChangeTitle) {
                actionVar.setDescVarName(this.actionValue);
            }
        }
        return true;
    }

    public boolean isTrue(JobVariable jobVariable) {
        String selected;
        int n;
        int n2;
        String[] stringArray;
        String varValue;
        if (this.con == Condition.EqualTo) {
            varValue = jobVariable.getValue();
            if (varValue != null && jobVariable.getDescVarType() == VariableDescriptor.VariableType.MultiSelectionList) {
                stringArray = varValue.split("\n");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    selected = stringArray[n];
                    if (selected.trim().equals(this.conValue)) {
                        return true;
                    }
                    ++n;
                }
            } else if (varValue != null && varValue.trim().equals(this.conValue)) {
                return true;
            }
        }
        if (this.con == Condition.NotEqualTo) {
            varValue = jobVariable.getValue();
            if (varValue != null && jobVariable.getDescVarType() == VariableDescriptor.VariableType.MultiSelectionList) {
                stringArray = varValue.split("\n");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    selected = stringArray[n];
                    if (selected.trim().equals(this.conValue)) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            if (varValue != null && !varValue.trim().equals(this.conValue)) {
                return true;
            }
        }
        if (this.con == Condition.Contain || this.con == Condition.NotContain) {
            boolean conditionEvalue;
            varValue = jobVariable.getValue();
            boolean bl = conditionEvalue = varValue != null && this.conValue != null && varValue.contains(this.conValue);
            if (this.con == Condition.Contain) {
                return conditionEvalue;
            }
            return !conditionEvalue;
        }
        if (this.con == Condition.True && (varValue = jobVariable.getValue()) != null && varValue.equalsIgnoreCase("true")) {
            return true;
        }
        return this.con == Condition.False && (varValue = jobVariable.getValue()) != null && (varValue.equalsIgnoreCase("false") || varValue.isEmpty());
    }

    public static void addRequiredRules(VariablesRule rule) {
        if (rule.action == Action.Enable) {
            new VariablesRule(rule.conVariable, rule.actionVar, rule.con, Action.SetToRequired, rule.conValue, true);
        }
    }

    public static enum Action {
        Enable,
        Disable,
        Reset,
        SetValueTo,
        SetToRequired,
        SetToNotRequired,
        ChangeTitle;

    }

    public static enum Condition {
        True,
        False,
        EqualTo,
        NotEqualTo,
        Contain,
        NotContain;

    }
}

