/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.pipelinestools.utils;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.pipelinestools.utils.PipelineProcessQuery;
import com.biotechvana.pipelinestools.utils.ProcessModel;
import com.biotechvana.users.UserManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ProcessQueryComposite
extends Composite {
    private Table table;
    private TableViewer tableViewer;
    private PipelineProcessQuery pipelineProcessQuery;
    private Runnable timer;

    public ProcessQueryComposite(Composite parent, int style, UserManager userManager) {
        super(parent, style);
        this.pipelineProcessQuery = PipelineProcessQuery.getInstance(userManager);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(1808));
        Label labelRunning = new Label((Composite)this, 0);
        labelRunning.setText("Running programs:");
        this.tableViewer = new TableViewer((Composite)this, 68354);
        this.table = this.tableViewer.getTable();
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 200;
        this.table.setLayoutData((Object)layoutData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        Label labelTimer = new Label((Composite)this, 64);
        labelTimer.setText("Note: running process list refreshes every 5 seconds.\nIf your process lasts less than this interval, you may not see that process in the list.");
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = ProcessQueryComposite.this.table.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = ProcessQueryComposite.this.table.getTopIndex();
                while (index < ProcessQueryComposite.this.table.getItemCount()) {
                    boolean visible = false;
                    TableItem item = ProcessQueryComposite.this.table.getItem(index);
                    int i = 0;
                    while (i < ProcessQueryComposite.this.table.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt) && i == 2) {
                            String pid = ProcessQueryComposite.this.table.getItem(index).getText(0);
                            if (MessageDialog.openConfirm((Shell)ProcessQueryComposite.this.getShell(), (String)"Kill process", (String)"Do you really want to stop this currently running process?")) {
                                try {
                                    ProcessQueryComposite.this.killProcess(Integer.parseInt(pid));
                                }
                                catch (Exception e) {
                                    MessageDialog.openInformation((Shell)ProcessQueryComposite.this.getShell(), (String)"Stop process", (String)"Error canceling selected process.\nPlease, close Omic analysis inerface and try again");
                                }
                            }
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
        this.initializeTable();
        this.addProviders();
        this.timer = new Runnable(){

            @Override
            public void run() {
                ProcessQueryComposite.this.queryProcesses();
                ProcessQueryComposite.this.getShell().getDisplay().timerExec(5000, (Runnable)this);
                ProcessQueryComposite.this.tableViewer.getTable().layout();
                ProcessQueryComposite.this.tableViewer.getTable().getColumn(ProcessQueryComposite.this.tableViewer.getTable().getColumnCount() - 1).pack();
            }
        };
        this.getShell().getDisplay().timerExec(5000, this.timer);
    }

    public void addDisposeListener(DisposeListener listener) {
        super.addDisposeListener(listener);
    }

    private void queryProcesses() {
        try {
            List<ProcessModel> listProcesses;
            if (this.pipelineProcessQuery != null && (listProcesses = this.pipelineProcessQuery.getListProcesses()) != null) {
                this.tableViewer.setInput(listProcesses);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void killProcess(int pid) {
        this.pipelineProcessQuery.getProcessQuery().killProcess(pid);
        try {
            this.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeTable() {
        TableViewerColumn colPid = new TableViewerColumn(this.tableViewer, 0);
        colPid.getColumn().setText("PID");
        colPid.getColumn().setWidth(60);
        colPid.getColumn().setResizable(true);
        colPid.getColumn().setMoveable(false);
        colPid.getColumn().setAlignment(0x1000000);
        TableViewerColumn colTime = new TableViewerColumn(this.tableViewer, 0);
        colTime.getColumn().setText("Time");
        colTime.getColumn().setWidth(60);
        colTime.getColumn().setResizable(true);
        colTime.getColumn().setMoveable(false);
        TableViewerColumn colActions = new TableViewerColumn(this.tableViewer, 0);
        colActions.getColumn().setText("Actions");
        colActions.getColumn().setWidth(60);
        colActions.getColumn().setResizable(true);
        colActions.getColumn().setMoveable(false);
        TableViewerColumn colCmd = new TableViewerColumn(this.tableViewer, 0);
        colCmd.getColumn().setText("Command");
        colCmd.getColumn().setWidth(500);
        colCmd.getColumn().setResizable(true);
        colCmd.getColumn().setMoveable(false);
    }

    private void addProviders() {
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList listProcess = (ArrayList)inputElement;
                return listProcess.toArray(new Object[listProcess.size()]);
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                ProcessModel pm = (ProcessModel)element;
                switch (columnIndex) {
                    case 0: {
                        return String.valueOf(pm.getPid());
                    }
                    case 1: {
                        return pm.getTime();
                    }
                    case 2: {
                        return "Stop";
                    }
                    case 3: {
                        return pm.getCmd();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 2) {
                    return SharedImages.CANCEL;
                }
                return null;
            }
        });
    }

    public void refresh() {
        try {
            List<ProcessModel> listProcess = this.pipelineProcessQuery.getProcessQuery().queryServer();
            this.tableViewer.setInput(listProcess);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

