/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.pipelinestools.utils;

import com.biotechvana.pipelineCommander.PipelineCommander;
import com.biotechvana.pipelinestools.utils.ProcessModel;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.IPrefs;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class ProcessQuery {
    public final String PROCESS_URL;
    public final String PROCESS_URL_SLURM;
    private String errorMessage = null;
    private static ProcessQuery processQuery;
    private final String[] excludeProcesses = new String[]{"vsftpd", "sshd:", "-bash", "htop", "SCREEN", "sh .command", "/bin/bash"};
    UserManager userManager;

    private ProcessQuery(UserManager userManager) {
        this.userManager = userManager;
        this.PROCESS_URL = "http://" + userManager.get("ssh_host", "") + "/gpro/pipelineCommander/queryProcess2.php";
        this.PROCESS_URL_SLURM = "http://" + userManager.get("ssh_host", "") + "/gpro/pipelineCommander/queryProcessSlurm.php";
    }

    @Deprecated
    public static ProcessQuery getInstance(UserManager userManager) {
        if (processQuery == null) {
            processQuery = new ProcessQuery(userManager);
        }
        return processQuery;
    }

    public boolean killProcess(int pid) {
        try {
            String username = this.userManager.get("ssh_user", "");
            String password = this.userManager.get("ssh_password", "");
            String emailAddress = this.userManager.get("email", "");
            PipelineCommander pc = new PipelineCommander(this.userManager.get("ssh_host", ""), (IPrefs)this.userManager);
            OutputStreamWriter output = new OutputStreamWriter(System.out);
            pc.prepareCommandRequest(username, password, "kill -9 " + pid, true, emailAddress, false);
            pc.postPipelineRequest((Writer)output);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<ProcessModel> queryServer() throws IOException {
        return this.queryServer(this.userManager.get("ssh_user", ""));
    }

    public List<ProcessModel> queryServer(String processName) throws IOException {
        String response;
        ArrayList<ProcessModel> listProcess = new ArrayList<ProcessModel>();
        String sshUser = this.userManager.get("ssh_user", "");
        if (sshUser == null || sshUser.length() == 0) {
            return listProcess;
        }
        URL queryUrl = new URL(this.PROCESS_URL);
        String runMode = this.userManager.get("PBS", "NO");
        if (runMode.equals("SLURM")) {
            queryUrl = new URL(this.PROCESS_URL_SLURM);
        }
        URLConnection connection = queryUrl.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        String content = "userName=" + URLEncoder.encode(sshUser, "UTF-8");
        if (processName != null && processName.length() > 0) {
            content = content + "&programName=" + URLEncoder.encode(processName, "UTF-8");
        }
        content = content + "&action=" + URLEncoder.encode("query", "UTF-8");
        outputStream.writeBytes(content);
        outputStream.flush();
        outputStream.close();
        DataInputStream inputStream = new DataInputStream(connection.getInputStream());
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((response = reader.readLine()) != null) {
            if (response.isEmpty()) continue;
            response = response.trim();
            try {
                String[] cols = response.trim().split("\\s+", 3);
                if (runMode.equals("SLURM")) {
                    cols = response.trim().split("\\s+");
                }
                boolean includeProcess = true;
                String[] stringArray = this.excludeProcesses;
                int n = this.excludeProcesses.length;
                int n2 = 0;
                while (n2 < n) {
                    String ep = stringArray[n2];
                    if (cols[2].contains(ep)) {
                        includeProcess = false;
                    }
                    ++n2;
                }
                if (!includeProcess) continue;
                if (runMode.equals("SLURM")) {
                    listProcess.add(new ProcessModel(cols[0].trim(), cols[5].trim(), cols[2].trim()));
                    continue;
                }
                listProcess.add(new ProcessModel(cols[0].trim(), cols[1].trim(), cols[2].trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return listProcess;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

