/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csvUtils;

import com.biotechvana.csvUtils.CSVUtils2;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GFFUtils
extends CSVUtils2 {
    public static final String ATT_SEQ_NAME = "SeqName";
    public static final String ATT_SOURCE = "Source";
    public static final String ATT_FEATURE_TYPE = "Feature";
    public static final String ATT_FEATURE_START = "Start";
    public static final String ATT_FEATURE_END = "End";
    public static final String ATT_FEATURE_SCORE = "Score";
    public static final String ATT_FEATURE_STRAND = "Strand";
    public static final String ATT_FEATURE_PHASE = "Phase";
    public static final int ATT_SEQ_NAME_INDEX = 0;
    public static final int ATT_SOURCE_INDEX = 1;
    public static final int ATT_FEATURE_TYPE_INDEX = 2;
    public static final int ATT_FEATURE_START_INDEX = 3;
    public static final int ATT_FEATURE_END_INDEX = 4;
    public static final int ATT_FEATURE_SCORE_INDEX = 5;
    public static final int ATT_FEATURE_STRAND_INDEX = 6;
    public static final int ATT_FEATURE_PHASE_INDEX = 7;
    public static final String NEGATIVE_STRAND = "-";
    List<String> attributesModel = new ArrayList<String>();

    protected GFFUtils(File csvFile, boolean hasHeader) {
        super(csvFile, hasHeader);
    }

    protected GFFUtils(String csvFile, boolean hasHeader) {
        super(csvFile, hasHeader);
    }

    @Override
    protected void parseSeparator() {
        this.parseSeparatorDone = true;
        this.separator = CSVUtils2.Separators.TAB.getSeparator();
    }

    @Override
    protected void parseHeaders() throws IOException {
        boolean counter = false;
        this.parseHeadersDone = true;
        if (this.headerList == null) {
            this.headerList = new ArrayList();
            this.headerList.add(ATT_SEQ_NAME);
            this.headerList.add(ATT_SOURCE);
            this.headerList.add(ATT_FEATURE_TYPE);
            this.headerList.add(ATT_FEATURE_START);
            this.headerList.add(ATT_FEATURE_END);
            this.headerList.add(ATT_FEATURE_SCORE);
            this.headerList.add(ATT_FEATURE_STRAND);
            this.headerList.add(ATT_FEATURE_PHASE);
        }
    }

    @Override
    protected void parseHeadersWithoutDelimiter() {
        try {
            this.parseHeaders();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getHeaders() throws IOException, CSVUtils2.ColumnCountNotDoneException, CSVUtils2.SeparatorNotParsedException, CSVUtils2.DelimiterNotParsedException {
        this.parseHeadersDone = true;
        if (this.headerList == null) {
            this.parseHeaders();
        }
        return this.headerList;
    }

    @Override
    public List<List<String>> getModel(boolean appendIndex, boolean force) throws IOException, InterruptedException, CSVUtils2.ModelNotParsedException {
        this.perserveDelimiter = true;
        super.getModel(appendIndex, force);
        HashMap<String, Integer> extraClms = new HashMap<String, Integer>();
        int numberOfExtraClms = 0;
        ArrayList extraModel = new ArrayList();
        for (List row : this.model) {
            String[] tokens;
            String lastItem = (String)row.get(row.size() - 1);
            this.attributesModel.add(lastItem);
            row.remove(lastItem);
            HashMap<String, String> extrRow = new HashMap<String, String>();
            String[] stringArray = tokens = lastItem.split(";");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String[] att_values;
                int firstIndex;
                int secondIndex;
                String token = stringArray[n2];
                token = token.trim();
                String value = "";
                if (token.contains("\"") && (secondIndex = token.indexOf(34, (firstIndex = token.indexOf(34)) + 1)) != -1) {
                    value = token.substring(firstIndex + 1, secondIndex);
                }
                if ((att_values = token.split(" |=")).length == 2 || token.contains("\"")) {
                    String key = att_values[0];
                    if (!token.contains("\"")) {
                        value = att_values[1];
                    }
                    if (!extraClms.containsKey(key)) {
                        extraClms.put(key, numberOfExtraClms);
                        ++numberOfExtraClms;
                    }
                    extrRow.put(key, URLDecoder.decode(value, "UTF-8"));
                }
                ++n2;
            }
            extraModel.add(extrRow);
        }
        for (String key : extraClms.keySet()) {
            if (this.headerList == null) {
                this.parseHeaders();
            }
            this.headerList.add(key);
        }
        int i = 0;
        while (i < this.model.size()) {
            List row = (List)this.model.get(i);
            HashMap extraRow = (HashMap)extraModel.get(i);
            for (String key : extraClms.keySet()) {
                if (extraRow.containsKey(key)) {
                    row.add((String)extraRow.get(key));
                    continue;
                }
                row.add(".");
            }
            ++i;
        }
        return this.model;
    }

    @Override
    protected void parseDelimiter() throws IOException {
        this.delimiter = (char)78;
        this.parseDelimiterDone = true;
    }

    public static boolean isEmpty(String value) {
        return value != null && !value.isEmpty() && !value.equals(".");
    }
}

