/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csvUtils;

import com.biotechvana.csvUtils.CSVUtils3;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class CsvMultiHspToSingleHsp {
    private int columnDatabaseIndex;
    private int columnQueryIndex;
    private int columnSubjectIndex;
    private int columnGiIndex;
    private int columnAccesionIndex;
    private int columnSpeciesIndex;
    private int columnScoreIndex;
    private int columnEvalueIndex;
    private int columnQueryFromIndex;
    private int columnQueryToIndex;
    private int columnSubjectFromIndex;
    private int columnSubjectToIndex;
    private int columnQueryFrameIndex;
    private int columnSubjectFrameIndex;
    private int columnIdentitiesIndex;
    private int columnPositivesIndex;
    private int columnQueryLenIndex;
    private int columnSubjectLenIndex;
    private int columnAlignLengthIndex;
    private int columnSimilarityIndex;
    private int columnHspQueryIndex;
    private int columnHspHitIndex;
    private int columnGoNumberIndex;
    private int columnGoIndex;
    private int columnEvidenceIndex;
    private int columnEnzymeIndex;
    private int columnInterproIndex;
    private int columnCommentsIndex;
    private char delimiter = (char)59;
    private char enclosure = (char)34;
    private File fileCsv;
    private File fileOutput;
    private boolean hasHeader;
    private String locale = "en";
    public static final String LOCALE_EN = "en";
    public static final String LOCALE_ES = "es";
    private DecimalFormat evalueFormat = new DecimalFormat("0.00E00");

    public static void main(String[] args) {
        CsvMultiHspToSingleHsp multi = new CsvMultiHspToSingleHsp(new File("/home/rfutami/Escritorio/blast_verify/report_REF_cDNA_Sparus_aurata_transcripts.csv"), new File("/home/rfutami/Escritorio/blast_verify/output.csv"), true);
        multi.setLocale(LOCALE_ES);
        try {
            multi.parseFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    CsvMultiHspToSingleHsp(File fileCsv, File fileOutput, boolean hasHeader) {
        this.fileCsv = fileCsv;
        this.fileOutput = fileOutput;
        this.hasHeader = hasHeader;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void parseFile() throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileOutput));){
            CSVUtils3 csvUtils = new CSVUtils3(this.fileCsv, this.delimiter, this.enclosure);
            csvUtils.parse();
            this.parseHeader(csvUtils.getHeaders());
            ArrayList<List<String>> sameSubject = new ArrayList<List<String>>();
            String lastQuery = null;
            String lastSubject = null;
            String lastSubjectFrameDirection = null;
            this.writeHeader(writer);
            List<List<String>> model = csvUtils.getModel();
            for (List<String> row : model) {
                String query = row.get(this.columnQueryIndex);
                String subject = row.get(this.columnSubjectIndex);
                String subjectFrame = row.get(this.columnSubjectFrameIndex);
                String subjectFrameDirection = "+";
                if (subjectFrame.equals("-1") || subjectFrame.equals("-2") || subjectFrame.equals("-3")) {
                    subjectFrameDirection = "-";
                }
                if (!subject.equals("No significant similarities found")) {
                    if (!(lastSubject == null || query.equals(lastQuery) && subject.equals(lastSubject) && subjectFrameDirection.equals(lastSubjectFrameDirection))) {
                        String joinedSubjects = this.parseSubject(sameSubject);
                        writer.append(String.valueOf(joinedSubjects) + "\n");
                        sameSubject = new ArrayList();
                    }
                    sameSubject.add(row);
                    lastSubject = subject;
                    lastSubjectFrameDirection = subjectFrameDirection;
                }
                lastQuery = query;
            }
            if (sameSubject != null && sameSubject.size() > 0) {
                String joinedSubjects = this.parseSubject(sameSubject);
                writer.append(String.valueOf(joinedSubjects) + "\n");
            }
        }
    }

    private void writeHeader(BufferedWriter writer) throws IOException {
        writer.append("\"db\"");
        writer.append(";\"Sequence\"");
        writer.append(";\"Subject mapping\"");
        writer.append(";\"GI\"");
        writer.append(";\"Accession\"");
        writer.append(";\"Species\"");
        writer.append(";\"Score\"");
        writer.append(";\"e-value\"");
        writer.append(";\"Query-from\"");
        writer.append(";\"Query-to\"");
        writer.append(";\"Subject-from\"");
        writer.append(";\"Subject-to\"");
        writer.append(";\"Query frame\"");
        writer.append(";\"Subject frame\"");
        writer.append(";\"Identities\"");
        writer.append(";\"Positives\"");
        writer.append(";\"Query length\"");
        writer.append(";\"Hit length\"");
        writer.append(";\"Align length\"");
        writer.append(";\"Similarity\"");
        writer.append(";\"Hsp/Query\"");
        writer.append(";\"Hsp/Hit\"");
        writer.append(";\"GO#\"");
        writer.append(";\"GO\"");
        writer.append(";\"Evidence codes\"");
        writer.append(";\"Enzyme codes\"");
        writer.append(";\"InterProScan\"");
        writer.append(";\"Comments\"");
        writer.append("\n");
    }

    private String parseSubject(List<List<String>> subjectRows) {
        StringBuilder builder = new StringBuilder();
        List<String> firstRow = subjectRows.get(0);
        float queryMin = this.getMin(subjectRows, this.columnQueryFromIndex);
        float queryMax = this.getMax(subjectRows, this.columnQueryToIndex);
        float subjectMin = this.getMin(subjectRows, this.columnSubjectFromIndex);
        float subjectMax = this.getMax(subjectRows, this.columnSubjectToIndex);
        float alignLen = this.getDistance(queryMin, queryMax);
        float queryLen = Float.parseFloat(firstRow.get(this.columnQueryLenIndex));
        float hitLen = Float.parseFloat(firstRow.get(this.columnSubjectLenIndex));
        String gosJoined = this.joinStrings(subjectRows, this.columnGoIndex, ";", true);
        int goCount = this.countMultipleValuesInString(gosJoined, ';');
        String evidencesJoined = this.joinStrings(subjectRows, this.columnEvidenceIndex, ";", true);
        String enzymesJoined = this.joinStrings(subjectRows, this.columnEnzymeIndex, ";", true);
        String interprosJoined = this.joinStrings(subjectRows, this.columnInterproIndex, ";", true);
        String commentsJoined = this.joinStrings(subjectRows, this.columnCommentsIndex, ";", true);
        builder.append("\"");
        builder.append(firstRow.get(this.columnDatabaseIndex));
        builder.append("\";\"");
        builder.append(firstRow.get(this.columnQueryIndex));
        builder.append("\";\"");
        builder.append(firstRow.get(this.columnSubjectIndex));
        builder.append("\";\"");
        builder.append(this.joinStrings(subjectRows, this.columnGiIndex, "|", true));
        builder.append("\";\"");
        builder.append(this.joinStrings(subjectRows, this.columnAccesionIndex, "|", true));
        builder.append("\";\"");
        builder.append(this.joinStrings(subjectRows, this.columnSpeciesIndex, "|", true));
        builder.append("\";\"");
        builder.append(this.formatToLocale(String.valueOf((int)this.getMean(subjectRows, this.columnScoreIndex))));
        builder.append("\";\"");
        builder.append(this.formatToLocale(this.evalueFormat.format(this.getEvalue(subjectRows, this.columnEvalueIndex))));
        builder.append("\";\"");
        builder.append(String.valueOf((int)queryMin));
        builder.append("\";\"");
        builder.append(String.valueOf((int)queryMax));
        builder.append("\";\"");
        builder.append(String.valueOf((int)subjectMin));
        builder.append("\";\"");
        builder.append(String.valueOf((int)subjectMax));
        builder.append("\";\"");
        builder.append(this.joinStrings(subjectRows, this.columnQueryFrameIndex, "|", true));
        builder.append("\";\"");
        builder.append(this.joinStrings(subjectRows, this.columnSubjectFrameIndex, "|", true));
        builder.append("\";\"");
        builder.append(this.formatToLocale(String.valueOf((int)this.getSum(subjectRows, this.columnIdentitiesIndex))));
        builder.append("\";\"");
        builder.append(this.formatToLocale(String.valueOf((int)this.getSum(subjectRows, this.columnPositivesIndex))));
        builder.append("\";\"");
        builder.append(String.valueOf((int)queryLen));
        builder.append("\";\"");
        builder.append(String.valueOf((int)hitLen));
        builder.append("\";\"");
        builder.append(String.valueOf((int)alignLen));
        builder.append("\";\"");
        builder.append(this.formatToLocale(String.format("%.2f", Float.valueOf(Math.abs(this.getMean(subjectRows, this.columnSimilarityIndex))))));
        builder.append("\";\"");
        builder.append(this.formatToLocale(String.format("%.2f", Float.valueOf(Math.abs(this.getAlignRatio(queryLen, alignLen))))));
        builder.append("\";\"");
        builder.append(this.formatToLocale(String.format("%.2f", Float.valueOf(Math.abs(this.getAlignRatio(hitLen, alignLen))))));
        builder.append("\";\"");
        builder.append(goCount);
        builder.append("\";\"");
        builder.append(gosJoined);
        builder.append("\";\"");
        builder.append(evidencesJoined);
        builder.append("\";\"");
        builder.append(enzymesJoined);
        builder.append("\";\"");
        builder.append(interprosJoined);
        builder.append("\";\"");
        builder.append(commentsJoined);
        builder.append("\"");
        return builder.toString();
    }

    private float getDistance(float min, float max) {
        return max - min;
    }

    private float getAlignRatio(float sequenceLen, float alignLen) {
        return alignLen / sequenceLen * 100.0f;
    }

    private void parseHeader(List<String> headerCols) {
        int i = 0;
        while (i < headerCols.size()) {
            String col = headerCols.get(i).toLowerCase();
            if (col.equals("database") || col.equals("db")) {
                this.columnDatabaseIndex = i;
            } else if (col.equals("sequence") || col.equals("query")) {
                this.columnQueryIndex = i;
            } else if (col.equals("subject mapping") || col.equals("subject_mapping") || col.equals("subject") || col.equals("hit mapping") || col.equals("hit_mapping") || col.equals("hit")) {
                this.columnSubjectIndex = i;
            } else if (col.equals("gi")) {
                this.columnGiIndex = i;
            } else if (col.equals("accession")) {
                this.columnAccesionIndex = i;
            } else if (col.equals("species")) {
                this.columnSpeciesIndex = i;
            } else if (col.equals("score")) {
                this.columnScoreIndex = i;
            } else if (col.equals("evalue") || col.equals("e_value") || col.equals("e-value") || col.equals("e value")) {
                this.columnEvalueIndex = i;
            } else if (col.equals("query_from") || col.equals("query from") || col.equals("query-from")) {
                this.columnQueryFromIndex = i;
            } else if (col.equals("query_to") || col.equals("query to") || col.equals("query-to")) {
                this.columnQueryToIndex = i;
            } else if (col.equals("subject_from") || col.equals("subject from") || col.equals("subject-from") || col.equals("hit_from") || col.equals("hit from") || col.equals("hit-from")) {
                this.columnSubjectFromIndex = i;
            } else if (col.equals("subject_to") || col.equals("subject to") || col.equals("subject-to") || col.equals("hit_to") || col.equals("hit to") || col.equals("hit-to")) {
                this.columnSubjectToIndex = i;
            } else if (col.equals("query frame") || col.equals("query_frame") || col.equals("query-frame")) {
                this.columnQueryFrameIndex = i;
            } else if (col.equals("subject frame") || col.equals("subject_frame") || col.equals("subject-frame") || col.equals("hit frame") || col.equals("hit_frame") || col.equals("hit-frame")) {
                this.columnSubjectFrameIndex = i;
            } else if (col.equals("identities")) {
                this.columnIdentitiesIndex = i;
            } else if (col.equals("positives")) {
                this.columnPositivesIndex = i;
            } else if (col.equals("query length") || col.equals("query_length") || col.equals("query-length") || col.equals("query len") || col.equals("query_len") || col.equals("query-len")) {
                this.columnQueryLenIndex = i;
            } else if (col.equals("hit length") || col.equals("hit_length") || col.equals("hit-length") || col.equals("subject length") || col.equals("subject_length") || col.equals("subject-length")) {
                this.columnSubjectLenIndex = i;
            } else if (col.equals("align length") || col.equals("align_length") || col.equals("align-length")) {
                this.columnAlignLengthIndex = i;
            } else if (col.equals("similarity")) {
                this.columnSimilarityIndex = i;
            } else if (col.equals("hsp/query")) {
                this.columnHspQueryIndex = i;
            } else if (col.equals("hsp/hit")) {
                this.columnHspHitIndex = i;
            } else if (col.equals("go#")) {
                this.columnGoNumberIndex = i;
            } else if (col.equals("go")) {
                this.columnGoIndex = i;
            } else if (col.equals("evidence codes")) {
                this.columnEvidenceIndex = i;
            } else if (col.equals("enzyme codes")) {
                this.columnEnzymeIndex = i;
            } else if (col.equals("interproscan")) {
                this.columnInterproIndex = i;
            } else if (col.equals("comments")) {
                this.columnCommentsIndex = i;
            }
            ++i;
        }
    }

    private double getEvalue(List<List<String>> rows, int columnIndex) {
        double result = 0.0;
        for (List<String> row : rows) {
            String valueText = row.get(columnIndex).trim();
            if (valueText.isEmpty()) continue;
            if ((valueText = this.sanitizeNumberValues(valueText)).equals("0")) {
                return 0.0;
            }
            result += Double.parseDouble(valueText);
        }
        return result;
    }

    private float getSum(List<List<String>> rows, int columnIndex) {
        float result = 0.0f;
        for (List<String> row : rows) {
            String valueText = row.get(columnIndex).trim();
            if (valueText.isEmpty()) continue;
            valueText = this.sanitizeNumberValues(valueText);
            result += Float.parseFloat(valueText);
        }
        return result;
    }

    private float getMean(List<List<String>> rows, int columnIndex) {
        float sum = 0.0f;
        int countElements = 0;
        for (List<String> row : rows) {
            String valueText = row.get(columnIndex).trim();
            if (valueText.isEmpty()) continue;
            valueText = this.sanitizeNumberValues(valueText);
            sum += Float.parseFloat(valueText);
            ++countElements;
        }
        if (countElements == 0) {
            return 0.0f;
        }
        return sum / (float)countElements;
    }

    private float getProduct(List<List<String>> rows, int columnIndex) {
        float result = 0.0f;
        for (List<String> row : rows) {
            String valueText = row.get(columnIndex).trim();
            if (valueText.isEmpty()) continue;
            valueText = this.sanitizeNumberValues(valueText);
            result *= Float.parseFloat(valueText);
        }
        return result;
    }

    private float getMin(List<List<String>> rows, int columnIndex) {
        float result = -1.0f;
        for (List<String> row : rows) {
            String valueText = row.get(columnIndex).trim();
            if (valueText.isEmpty()) continue;
            valueText = this.sanitizeNumberValues(valueText);
            float valueFloat = Float.parseFloat(valueText);
            if (result != -1.0f && !(valueFloat < result)) continue;
            result = valueFloat;
        }
        return result;
    }

    private float getMax(List<List<String>> rows, int columnIndex) {
        float result = 0.0f;
        for (List<String> row : rows) {
            float valueFloat;
            String valueText = row.get(columnIndex).trim();
            if (valueText.isEmpty() || !((valueFloat = Float.parseFloat(valueText = this.sanitizeNumberValues(valueText))) > result)) continue;
            result = valueFloat;
        }
        return result;
    }

    private String joinStrings(List<List<String>> rows, int columnIndex, String glue, boolean removeDuplicates) {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> listValues = new ArrayList<String>();
        for (List<String> row : rows) {
            if (removeDuplicates) {
                if (listValues.contains(row.get(columnIndex))) continue;
                listValues.add(row.get(columnIndex));
                continue;
            }
            listValues.add(row.get(columnIndex));
        }
        if (listValues.size() == 0) {
            return "";
        }
        if (listValues.size() == 1) {
            return (String)listValues.get(0);
        }
        builder.append((String)listValues.get(0));
        int i = 1;
        while (i < listValues.size()) {
            builder.append(String.valueOf(glue) + (String)listValues.get(i));
            ++i;
        }
        return builder.toString();
    }

    private int countMultipleValuesInString(String text, char glue) {
        int counter = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == glue) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    private String sanitizeNumberValues(String numberValue) {
        return numberValue.replace(",", ".").replace("e", "E").trim();
    }

    private String formatToLocale(String inputValue) {
        if (inputValue.equals("0.0") || inputValue.equals("0,0") || inputValue.equals("0,00E00") || inputValue.equals("0.00E00")) {
            return "0";
        }
        if (this.locale.equals(LOCALE_EN)) {
            return inputValue.replace(",", ".");
        }
        if (this.locale.equals(LOCALE_ES)) {
            return inputValue.replace(".", ",");
        }
        return inputValue;
    }
}

