/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.views;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.ui.widgets.WorkflowVis;
import com.biotechvana.workflow.views.WorkflowJobBasicComposite;
import com.biotechvana.workflow.views.WorkflowJobClassicComposite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WorkflowTabsComposite
extends Composite
implements Observer {
    static final int hIndent = 25;
    FormToolkit toolkit;
    Workflow workflow;
    int style;
    Composite parent;
    TabFolder upperFolder;
    IPipelineConfiguration basicConfig;
    Form detailsForm;
    private Composite mainBody;
    WorkflowVis preWorkflowVis;
    IWorkflowManager workflowManager;
    IEclipseContext cntx;
    Section jobDescriptionSection;
    Composite jobDescPart;
    private static final int MIN_WIDTH = 800;
    protected static final int MAX_WIDTH = 1000;
    List<WorkflowJobBasicComposite> cjobs = new ArrayList<WorkflowJobBasicComposite>();
    boolean isValid = true;
    String validMsg = "";

    public WorkflowTabsComposite(IWorkflowManager workflowManager, IPipelineConfiguration basicConfig, IEclipseContext cntx, Composite parent, int style) {
        super(parent, style);
        this.workflow = basicConfig.getWorkflow();
        this.basicConfig = basicConfig;
        this.style = style;
        this.parent = parent;
        this.workflowManager = workflowManager;
        this.cntx = cntx;
        this.toolkit = new FormToolkit(this.getDisplay());
        this.setLayout((Layout)new FillLayout());
        this.workflow.bind((Observer)this);
        this.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                System.out.println(event.detail);
                int eventType = event.detail;
                if (eventType == 100) {
                    System.out.println("EVENT_LAYOUT_CHANGED ");
                    WorkflowTabsComposite.this.upperFolder.layout(true);
                    TabItem[] tabItemArray = WorkflowTabsComposite.this.upperFolder.getSelection();
                    int n = tabItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TabItem item = tabItemArray[n2];
                        if (item.getControl() instanceof Composite) {
                            ((Composite)item.getControl()).layout(true);
                        }
                        ++n2;
                    }
                }
            }
        });
        this.createFormAndSection(this);
        this.upperFolder = new TabFolder(this.detailsForm.getBody(), 0);
        this.upperFolder.setForeground(this.getDisplay().getSystemColor(24));
        this.upperFolder.setBackground(this.getDisplay().getSystemColor(25));
        GridData gd = new GridData(1808);
        gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 25;
        this.upperFolder.setLayoutData((Object)gd);
        this.renderWorkflowTabs();
        this.upperFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TabItem[] items = WorkflowTabsComposite.this.upperFolder.getSelection();
                if (items.length > 0) {
                    WorkflowJob selectedJob = (WorkflowJob)items[0].getData();
                    if (!WorkflowTabsComposite.this.jobDescPart.isDisposed()) {
                        WorkflowTabsComposite.this.jobDescPart.dispose();
                    }
                    WorkflowTabsComposite.this.jobDescPart = WorkflowTabsComposite.this.toolkit.createComposite((Composite)WorkflowTabsComposite.this.jobDescriptionSection.getClient());
                    GridData layoutData = new GridData(4, 1, true, false);
                    layoutData.widthHint = 0;
                    layoutData.horizontalIndent = 25;
                    WorkflowTabsComposite.this.jobDescPart.setLayoutData((Object)layoutData);
                    WorkflowTabsComposite.this.jobDescPart.setLayout((Layout)new GridLayout(1, false));
                    WorkflowJobBasicComposite.addDescText(selectedJob, WorkflowTabsComposite.this.jobDescPart, WorkflowTabsComposite.this.toolkit);
                    WorkflowTabsComposite.this.jobDescPart.redraw();
                    WorkflowTabsComposite.this.jobDescriptionSection.layout(true);
                    WorkflowTabsComposite.this.detailsForm.layout(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label blankLabel = this.toolkit.createLabel(this.detailsForm.getBody(), "");
        gd = new GridData(4, 1, false, false, 1, 1);
        gd.widthHint = 25;
        blankLabel.setLayoutData((Object)gd);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WorkflowTabsComposite.this.workflow.deleteObserver((Observer)WorkflowTabsComposite.this);
            }
        });
    }

    private void createFormAndSection(Composite parent) {
        this.detailsForm = this.toolkit.createForm(parent);
        this.detailsForm.setText(this.workflow.getMetadata().getName());
        this.detailsForm.addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter());
        this.toolkit.decorateFormHeading(this.detailsForm);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        this.detailsForm.getBody().setLayout((Layout)layout);
        this.detailsForm.setImage(SharedImages.ACCEPT);
        this.detailsForm.getToolBarManager().add((IAction)new Action("Run"){
            {
                this.setImageDescriptor(SharedImages.RUNNING_DESC);
            }

            public void run() {
                WorkflowTabsComposite.this.runPipeline();
            }
        });
        this.detailsForm.getToolBarManager().add((IAction)new Action("Help"){
            {
                this.setImageDescriptor(SharedImages.RUNNING_DESC);
                this.setImageDescriptor(SharedImages.HELP_DESC);
                this.setToolTipText("Toggle Help/Manual");
            }

            public void run() {
                WorkflowTabsComposite.this.toggleVarHelpMsg();
            }
        });
        this.detailsForm.getToolBarManager().update(true);
        this.mainBody = this.detailsForm.getBody();
        this.createDescSection();
        Label blankLabel = this.toolkit.createLabel(this.detailsForm.getBody(), "");
        GridData gridData = new GridData(4, 1, false, false, 1, 1);
        gridData.widthHint = 25;
        blankLabel.setLayoutData((Object)gridData);
    }

    protected void toggleVarHelpMsg() {
        for (WorkflowJobBasicComposite cjob : this.cjobs) {
            cjob.toggleVarHelpMsg();
        }
    }

    private void createDescSection() {
        this.jobDescriptionSection = this.toolkit.createSection(this.mainBody, 258);
        this.jobDescriptionSection.setActiveToggleColor(this.toolkit.getHyperlinkGroup().getActiveForeground());
        this.jobDescriptionSection.setToggleColor(this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        this.toolkit.createCompositeSeparator((Composite)this.jobDescriptionSection);
        this.jobDescriptionSection.setText("Overview");
        this.jobDescriptionSection.setExpanded(true);
        this.jobDescriptionSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
            }
        });
        GridData gd = new GridData(1808);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 25;
        this.jobDescriptionSection.setLayoutData((Object)gd);
        Composite client = (Composite)this.jobDescriptionSection.getClient();
        try {
            if (client != null && !client.isDisposed()) {
                client.dispose();
            }
        }
        catch (SWTException swtEx) {
            swtEx.printStackTrace();
        }
        client = this.toolkit.createComposite((Composite)this.jobDescriptionSection, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        String txt = this.workflow.getMetadata().getDesc();
        FormText ft = this.toolkit.createFormText(client, false);
        GridData layoutData = new GridData(4, 1, true, false);
        layoutData.widthHint = 0;
        layoutData.horizontalIndent = 25;
        ft.setLayoutData((Object)layoutData);
        ft.setText("<form><p><b>Pipeline Description :</b><br></br>   " + txt + "</p></form>", true, false);
        FontData fontdata = ft.getFont().getFontData()[0];
        fontdata.setHeight(12);
        Font font = new Font((Device)this.getDisplay(), fontdata);
        ft.setFont(font);
        this.preWorkflowVis = new WorkflowVis(client, 2048, this.workflowManager);
        layoutData = new GridData(4, 1, false, false, 1, 2);
        layoutData.widthHint = 350;
        layoutData.heightHint = 250;
        layoutData.horizontalIndent = 25;
        this.preWorkflowVis.setLayoutData((Object)layoutData);
        this.jobDescriptionSection.setClient((Control)client);
        this.jobDescriptionSection.layout(true);
        this.preWorkflowVis.setWorkflow(this.workflow, false);
        this.preWorkflowVis.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.jobDescPart = this.toolkit.createComposite(client);
        layoutData = new GridData(4, 1, true, false);
        layoutData.widthHint = 0;
        layoutData.horizontalIndent = 25;
        this.jobDescPart.setLayoutData((Object)layoutData);
        this.jobDescPart.setLayout((Layout)new GridLayout(1, false));
    }

    private void renderWorkflowTabs() {
        List jobs = this.workflow.getAllJobs();
        for (WorkflowJob job : jobs) {
            TabItem item1 = new TabItem(this.upperFolder, 0);
            if (job instanceof WorkflowStartupJob) {
                item1.setText("Pipeline Configuration");
                item1.setToolTipText("Configure and edit most of the required input and optional parameters of the pipeline.");
            } else {
                item1.setText(job.getFriendlyName());
                item1.setToolTipText("Configure and edit specific input and optional parameters to " + job.getFriendlyName() + " job.");
            }
            WorkflowJobClassicComposite jobComposite = new WorkflowJobClassicComposite(this.workflowManager, job, (Composite)this.upperFolder, 0, this.toolkit, false, false);
            this.cjobs.add(jobComposite);
            item1.setData((Object)job);
            item1.setControl((Control)jobComposite);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        System.out.print("update in WorkflowTabsComposite");
        if (this.isDisposed()) {
            System.out.print("update isDisposed in WorkflowTabsComposite");
            o.deleteObserver(this);
            return;
        }
        Event e = new Event();
        e.detail = (Integer)arg;
        this.notifyListeners(24, e);
    }

    public void dispose() {
        System.out.print("dispose in WorkflowTabsComposite");
        this.upperFolder.dispose();
        for (WorkflowJobBasicComposite cjob : this.cjobs) {
            if (cjob.isDisposed()) continue;
            cjob.dispose();
        }
        this.workflow.deleteObserver((Observer)this);
        super.dispose();
    }

    public void runPipeline() {
        HashMap<WorkflowJob, Boolean> valids = new HashMap<WorkflowJob, Boolean>();
        if (!this.validate()) {
            MessageDialog.openWarning((Shell)this.parent.getShell(), (String)"Invalid Configuration", (String)this.validMsg);
            for (WorkflowJobBasicComposite cjob : this.cjobs) {
                boolean isValid = cjob.checkValidation();
                valids.put(cjob.getWorkflowJob(), isValid);
                this.preWorkflowVis.setValidationStatus(valids);
            }
        } else {
            IValidationResult result = this.workflowManager.submitPipeline(this.basicConfig);
            if (result.isOK()) {
                for (WorkflowJobBasicComposite cjob : this.cjobs) {
                    boolean isValid = true;
                    valids.put(cjob.getWorkflowJob(), isValid);
                    this.preWorkflowVis.setValidationStatus(valids);
                }
                MessageDialog.openInformation((Shell)this.parent.getShell(), (String)"Submission Successful.", (String)"Pipeline has been submitted to the server. You Can track it's progress from the Sumbission History.");
            } else {
                MessageDialog.openWarning((Shell)this.parent.getShell(), (String)"Configuration  Error.", (String)("Please revise your configuration. " + result.getMessage()));
                for (WorkflowJobBasicComposite cjob : this.cjobs) {
                    boolean isValid = cjob.checkValidation();
                    valids.put(cjob.getWorkflowJob(), isValid);
                    this.preWorkflowVis.setValidationStatus(valids);
                }
            }
        }
    }

    protected boolean validate() {
        IValidationResult validationResult;
        this.basicConfig.feedWorkflow();
        this.isValid = true;
        this.validMsg = "";
        if (this.isValid && !(validationResult = this.basicConfig.validate()).isOK()) {
            this.isValid = false;
            this.validMsg = validationResult.getMessage();
        }
        return this.isValid;
    }
}

