/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.groups.ui;

import com.biotechvana.workflow.groups.ExperimentGroup;
import com.biotechvana.workflow.groups.GroupAssignment;
import com.biotechvana.workflow.groups.ui.ExampleTableLabelProvider;
import com.biotechvana.workflow.groups.ui.GroupClmEditingSupport;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class GroupAssignmentControl {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private List<ExperimentGroup> groups;
    private HashMap<String, ExperimentGroup> groupsMap = new HashMap();
    private Collection<String> library;
    TableViewer tableViewer;
    GroupClmEditingSupport exampleEditingSupport;
    private String sampleClmTitle = "Sample";
    private String groupClmTitle = "Group";
    GroupAssignment[] input;

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public Composite createControl(Composite parent) {
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        Table exampleTable = new Table(parent, 68096);
        exampleTable.setLinesVisible(true);
        exampleTable.setHeaderVisible(true);
        exampleTable.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(exampleTable);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewerColumn labelColumn = new TableViewerColumn(this.tableViewer, 0);
        labelColumn.getColumn().setText(this.sampleClmTitle);
        TableViewerColumn valueColumn = new TableViewerColumn(this.tableViewer, 0);
        valueColumn.getColumn().setText(this.groupClmTitle);
        this.exampleEditingSupport = new GroupClmEditingSupport(this, valueColumn.getViewer());
        valueColumn.setEditingSupport((EditingSupport)this.exampleEditingSupport);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExampleTableLabelProvider());
        this.updateTable();
        parent.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                GroupAssignmentControl.this.updateTable();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        return exampleTable;
    }

    public void setLibrary(Collection<String> library) {
        Assert.isNotNull(library);
        this.library = library;
        this.updateTable();
    }

    private void updateTable() {
        this.input = new GroupAssignment[this.library.size()];
        int i = 0;
        for (String item : this.library) {
            this.input[i] = new GroupAssignment(item);
            ++i;
        }
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)this.input);
        }
    }

    public void setGroupAssignments(HashMap<String, List<String>> groupAssignments) {
        this.input = new GroupAssignment[this.library.size()];
        HashMap<String, String> libToGroup = new HashMap<String, String>();
        for (String group : groupAssignments.keySet()) {
            for (String sample : groupAssignments.get(group)) {
                libToGroup.put(sample, group);
            }
        }
        int i = 0;
        for (String item : this.library) {
            this.input[i] = new GroupAssignment(item);
            this.input[i].setExperimentGroup(this.groupsMap.get(libToGroup.get(item)));
            ++i;
        }
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)this.input);
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public List<ExperimentGroup> getGroups() {
        return this.groups;
    }

    public GroupAssignment[] getGroupAssignments() {
        return this.input;
    }

    public void setGroups(List<ExperimentGroup> experimentGroups) {
        this.groups = experimentGroups;
        this.groupsMap.clear();
        for (ExperimentGroup group : this.groups) {
            this.groupsMap.put(group.getGroupLabel(), group);
        }
        this.exampleEditingSupport.updateGroups();
        this.tableViewer.refresh();
    }

    public void removeGroup(ExperimentGroup removed) {
        this.groups.remove(removed);
        GroupAssignment[] groupAssignmentArray = this.input;
        int n = this.input.length;
        int n2 = 0;
        while (n2 < n) {
            GroupAssignment assignment = groupAssignmentArray[n2];
            if (removed.contains(assignment.getSampleLabel())) {
                assignment.setExperimentGroup(null);
            }
            ++n2;
        }
        this.exampleEditingSupport.updateGroups();
        this.tableViewer.refresh();
        this.notifyChange();
    }

    public void notifyChange() {
        this.support.firePropertyChange("groupsAssignment", null, this.input);
    }
}

