/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.fileExplorerBasic.dialogs;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.users.UserManager;
import java.io.File;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WorkspaceDialog
extends TitleAreaDialog {
    public final String WORKSPACE_PREF_KEY = "workspace";
    private Text textWorkspace;
    private Button buttonWorkspace;
    private Button buttonRemember;
    private File fileWorkspace = new File(System.getProperty("user.home"));
    String prefWorkspace;
    UserManager userManager;

    public WorkspaceDialog(Shell parentShell, UserManager userManager) {
        super(parentShell);
        this.userManager = userManager;
    }

    public void create() {
        super.create();
        this.setTitle("Select workspace");
        this.setMessage("Select a workspace directory to manage your project files");
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(compositeParent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        GridData layoutData = new GridData();
        Label labelWorkspace = new Label(composite, 0);
        labelWorkspace.setText("Select workspace:");
        labelWorkspace.setLayoutData((Object)layoutData);
        this.textWorkspace = new Text(composite, 2052);
        this.prefWorkspace = this.userManager.get("workspace", "");
        if (this.prefWorkspace.isEmpty()) {
            File fileWorkspace = new File(System.getProperty("user.home"));
            this.prefWorkspace = fileWorkspace.getAbsolutePath();
        }
        this.textWorkspace.setText(this.prefWorkspace);
        layoutData = new GridData(768);
        this.textWorkspace.setLayoutData((Object)layoutData);
        this.buttonWorkspace = new Button(composite, 8);
        this.buttonWorkspace.setText("Browse");
        this.buttonWorkspace.setImage(SharedImages.FOLDER);
        layoutData = new GridData();
        this.buttonWorkspace.setLayoutData((Object)layoutData);
        this.buttonRemember = new Button(composite, 32);
        this.buttonRemember.setText("Remember settings");
        this.buttonRemember.setSelection(true);
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        this.buttonRemember.setLayoutData((Object)layoutData);
        this.addListeners();
        return super.createDialogArea(parent);
    }

    private void addListeners() {
        this.buttonWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceDialog.this.browseWorkspace();
            }
        });
    }

    protected void okPressed() {
        String directory = this.textWorkspace.getText();
        if (directory == null) {
            return;
        }
        this.prefWorkspace = directory;
        if (this.buttonRemember.getSelection()) {
            this.userManager.put("workspace", this.prefWorkspace);
            this.userManager.savePreferences();
        }
        super.okPressed();
    }

    private void browseWorkspace() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4);
        if (this.prefWorkspace != null) {
            dialog.setFilterPath(this.prefWorkspace);
        } else {
            dialog.setFilterPath(this.fileWorkspace.getAbsolutePath());
        }
        String res = dialog.open();
        if (res == null) {
            return;
        }
        this.prefWorkspace = res;
        this.textWorkspace.setText(res);
    }

    public File getWorkspace() {
        return new File(this.prefWorkspace);
    }
}

