/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.servercommons.dialogs.preferences;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.model.ServiceStatus;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ServicesStatusComposite
extends Composite {
    private TableViewer viewer;
    int currentIndex = 0;
    Job checkJob;

    public ServicesStatusComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(parent, 68354);
        this.createColumns();
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private void createColumns() {
        TableViewerColumn colServiceName = new TableViewerColumn(this.viewer, 0);
        colServiceName.getColumn().setWidth(200);
        colServiceName.getColumn().setText("Name");
        colServiceName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ServiceStatus p = (ServiceStatus)element;
                return p.getName();
            }
        });
        TableViewerColumn colServiceStatus = new TableViewerColumn(this.viewer, 0);
        colServiceStatus.getColumn().setWidth(200);
        colServiceStatus.getColumn().setText("Status");
        colServiceStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ServiceStatus p = (ServiceStatus)element;
                return p.getStatus();
            }

            public Image getImage(Object element) {
                ServiceStatus p = (ServiceStatus)element;
                if (p.getStatus() == "OK") {
                    return SharedImages.ACCEPT;
                }
                if (p.getStatus() == "Fail") {
                    return SharedImages.ERROR;
                }
                return null;
            }
        });
    }

    public void start(List<ServiceStatus> serviceSs) {
        this.viewer.setInput(serviceSs);
        this.checkJob = Job.create((String)"GPRO Status Check", monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)serviceSs.size());
            try {
                this.showBusy(true);
                for (ServiceStatus s : serviceSs) {
                    if (subMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.processTodo(subMonitor.newChild(1), s);
                }
                this.showBusy(false);
            }
            catch (Exception e) {
                return Status.CANCEL_STATUS;
            }
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        });
        this.checkJob.schedule();
    }

    private void processTodo(SubMonitor newChild, ServiceStatus s) {
        newChild.beginTask(s.getName(), -1);
        s.setStatus("Checking ... ");
        this.syncUI(s);
        s.updateStatus();
        this.syncUI(s);
    }

    private void syncUI(final ServiceStatus s) {
        if (!this.getDisplay().isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ServicesStatusComposite.this.viewer.refresh((Object)s);
                }
            });
        }
    }

    private void showBusy(final boolean show) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (show) {
                    Cursor cursor = ServicesStatusComposite.this.getDisplay().getSystemCursor(1);
                    ServicesStatusComposite.this.viewer.getTable().setCursor(cursor);
                } else {
                    ServicesStatusComposite.this.viewer.getTable().setCursor(null);
                }
            }
        });
    }

    public void cancel() {
        this.checkJob.cancel();
    }
}

