/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.servercommons;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.concurrent.Callable;

class TaskChecker
implements Callable<String> {
    private final String UPDATE_AVAILABLE_KEY = "UPDATE_AVAILABLE=";
    private final String UPDATE_MESSAGE_KEY = "MESSAGE=";
    private String appName;
    private String appVersion;
    private String updateAvailable = "no";
    private String updateMessage = "";

    public TaskChecker(String appName, String appVersion) {
        this.appName = appName;
        this.appVersion = appVersion;
    }

    @Override
    public String call() throws Exception {
        URL url = new URL("http://biotechvana.com/gpro/update_check.php?app_name=" + this.appName + "&app_version=" + this.appVersion.replace(".", "%2E"));
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("UPDATE_AVAILABLE=")) {
                    this.updateAvailable = line.replace("UPDATE_AVAILABLE=", "");
                    continue;
                }
                if (!line.startsWith("MESSAGE=")) continue;
                this.updateMessage = line.replace("MESSAGE=", "");
            }
            if (this.updateAvailable.toLowerCase().equals("yes")) {
                System.out.println("message: " + this.updateMessage);
            } else {
                System.out.println("message: " + this.updateMessage);
            }
        }
        return null;
    }

    public String getMessage() {
        return this.updateMessage;
    }

    public boolean updateAvailable() {
        return this.updateAvailable.equalsIgnoreCase("yes");
    }
}

