/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.commons.model;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.commons.model.ILocalFile;
import com.biotechvana.commons.model.UserNotifyListener;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.Util;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class FTPHelper {
    static Logger LOGGER = LoggerFactory.getLogger(FTPHelper.class);
    public static DecimalFormat mbFormat = new DecimalFormat("####.##");
    public static final int OK = 1;
    public static final int ERROR = -1;
    public static final int FILE_EXISTS = -2;
    public static final int BUFFER_SIZE = 819200;
    UserNotifyListener userNotifyListener;
    IFTPManager ftpManagerImpl;

    @Inject
    public void setFTPManager(IFTPManager ftpmanager) {
        this.ftpManagerImpl = ftpmanager;
    }

    public boolean downloadFile(String remoteFilePath, String localDestFolder) throws FileNotFoundException, IOException {
        return this.downloadFile(remoteFilePath, localDestFolder, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean downloadFile(String remoteFilePath, String localDestFolder, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ILocalFile localFolder = this.ftpManagerImpl.resolveLocalFile(localDestFolder);
        IRemoteFile remoteFile = this.ftpManagerImpl.resolveRemoteFile(remoteFilePath);
        FileObject sourceFile = (FileObject)remoteFile.getFileObject();
        FileObject destination = (FileObject)localFolder.getFileObject();
        return this.transferFile(sourceFile, destination, monitor);
    }

    public boolean downloadFile(IRemoteFile remoteFilePath, String localDestFolder) throws FileNotFoundException, IOException {
        return this.downloadFile(remoteFilePath, localDestFolder, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean downloadFile(IRemoteFile remoteFilePath, String localDestFolder, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        FileObject sourceFile = (FileObject)remoteFilePath.getFileObject();
        ILocalFile localFolder = this.ftpManagerImpl.resolveLocalFile(localDestFolder);
        FileObject destination = (FileObject)localFolder.getFileObject();
        return this.transferFile(sourceFile, destination, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean uploadFile(String localFilepath, String remoteDestFolderPath) throws FileNotFoundException, IOException {
        return this.uploadFile(localFilepath, remoteDestFolderPath, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean uploadFile(String localFilepath, String remoteDestFolderPath, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ILocalFile localFile = this.ftpManagerImpl.resolveLocalFile(localFilepath);
        IRemoteFile remoteDestFolder = this.ftpManagerImpl.resolveRemoteFile(remoteDestFolderPath);
        FileObject sourceFile = (FileObject)localFile.getFileObject();
        FileObject destination = (FileObject)remoteDestFolder.getFileObject();
        return this.transferFile(sourceFile, destination, monitor);
    }

    protected boolean transferFile(FileObject sourceFile, FileObject destination, final IProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(sourceFile.getName().getPath());
        }
        FileObject destinationFile = destination;
        if (!destination.isFile()) {
            destinationFile = destination.resolveFile(destination.getName().getPath() + "/" + sourceFile.getName().getBaseName());
        }
        if (FileObjectUtils.exists((FileObject)destinationFile) && destinationFile.getType() != sourceFile.getType()) {
            destinationFile.deleteAll();
        }
        try {
            if (sourceFile.getType().hasContent()) {
                FTPHelper.writeContent(sourceFile, destinationFile, new CopyStreamListener(){

                    public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }

                    public void bytesTransferred(CopyStreamEvent event) {
                    }
                });
                monitor.done();
                return true;
            }
        }
        catch (FileSystemException e) {
            throw new IOException(e);
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        return false;
    }

    protected boolean transferFolder(FileObject sourceFolder, FileObject destinationFolder, IProgressMonitor monitor) throws IOException {
        ArrayList sourceFiles = new ArrayList();
        sourceFolder.findFiles(Selectors.SELECT_ALL, false, sourceFiles);
        long totalTransferSize = 0L;
        for (FileObject sourceFile : sourceFiles) {
            if (!sourceFile.isFile()) continue;
            totalTransferSize += sourceFile.getContent().getSize();
            String relPath = sourceFolder.getName().getRelativeName(sourceFile.getName());
            FileObject destinationFile = destinationFolder.resolveFile(relPath, NameScope.DESCENDENT_OR_SELF);
            FTPHelper.writeContent(sourceFile, destinationFile, new CopyStreamListener(){

                public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                }

                public void bytesTransferred(CopyStreamEvent event) {
                }
            });
        }
        return false;
    }

    public boolean uploadFileFromString(String fileContent, String remoteFolder, String fileName, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        monitor.subTask("Uploading  : " + fileName);
        String remoteFilePath = remoteFolder + "/" + fileName;
        IRemoteFile remoteDestFolder = this.ftpManagerImpl.resolveRemoteFile(remoteFilePath);
        FileObject destinationFile = (FileObject)remoteDestFolder.getFileObject();
        ByteArrayInputStream strInput = new ByteArrayInputStream(fileContent.getBytes());
        FTPHelper.writeContent(strInput, destinationFile, new CopyStreamListener(){

            public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
            }

            public void bytesTransferred(CopyStreamEvent event) {
            }
        });
        return true;
    }

    public boolean uploadFolder(String localFolder, String remoteFolder, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ILocalFile localFile = this.ftpManagerImpl.resolveLocalFile(localFolder);
        IRemoteFile remoteDestFolder = this.ftpManagerImpl.resolveRemoteFile(remoteFolder);
        FileObject sourceFolder = (FileObject)localFile.getFileObject();
        FileObject destinationFolder = (FileObject)remoteDestFolder.getFileObject();
        return this.transferFolder(sourceFolder, destinationFolder, monitor);
    }

    public boolean downloadFolder(String remoteFolderPath, String localFolderPath) throws IOException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ILocalFile localFolder = this.ftpManagerImpl.resolveLocalFile(localFolderPath);
        IRemoteFile remoteFolder = this.ftpManagerImpl.resolveRemoteFile(remoteFolderPath);
        FileObject sourceFolder = (FileObject)remoteFolder.getFileObject();
        FileObject destinationFolder = (FileObject)localFolder.getFileObject();
        return this.transferFolder(sourceFolder, destinationFolder, (IProgressMonitor)monitor);
    }

    public IFTPManager getFTPManager() {
        return this.ftpManagerImpl;
    }

    private static void writeContent(FileObject sourceFile, FileObject destinationFile, CopyStreamListener progressMonitor) throws IOException {
        try (InputStream sourceFileIn = sourceFile.getContent().getInputStream();
             OutputStream destinationFileOut = destinationFile.getContent().getOutputStream();){
            Util.copyStream((InputStream)sourceFileIn, (OutputStream)destinationFileOut, (int)0x7D0000, (long)sourceFile.getContent().getSize(), (CopyStreamListener)progressMonitor);
        }
    }

    private static void writeContent(InputStream sourceFileIn, FileObject destinationFile, CopyStreamListener progressMonitor) throws IOException {
        try (OutputStream destinationFileOut = destinationFile.getContent().getOutputStream();){
            Util.copyStream((InputStream)sourceFileIn, (OutputStream)destinationFileOut, (int)0x7D0000, (long)-1L, (CopyStreamListener)progressMonitor);
        }
        finally {
            sourceFileIn.close();
        }
    }

    public IRemoteFile createDirectories(String path) {
        if (this.ftpManagerImpl.createFolder(path)) {
            try {
                return this.ftpManagerImpl.resolveRemoteFile(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

